/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.model;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import org.apache.karaf.features.internal.model.Conditional;
import org.apache.karaf.features.internal.model.Content;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="feature", propOrder={"details", "config", "configfile", "feature", "bundle", "conditional"})
public class Feature
extends Content
implements org.apache.karaf.features.Feature {
    public static String SPLIT_FOR_NAME_AND_VERSION = "_split_for_name_and_version_";
    public static String DEFAULT_VERSION = "0.0.0";
    protected String details;
    @XmlAttribute(required=true)
    protected String name;
    @XmlAttribute
    protected String version;
    @XmlAttribute
    protected String description;
    @XmlAttribute
    protected String resolver;
    @XmlAttribute
    protected String install;
    @XmlAttribute(name="start-level")
    protected Integer startLevel;
    @XmlAttribute
    protected String region;
    protected List<Conditional> conditional;

    public Feature() {
    }

    public Feature(String name) {
        this.name = name;
    }

    public Feature(String name, String version) {
        this.name = name;
        this.version = version;
    }

    public static org.apache.karaf.features.Feature valueOf(String str) {
        if (str.indexOf(SPLIT_FOR_NAME_AND_VERSION) >= 0) {
            String strName = str.substring(0, str.indexOf(SPLIT_FOR_NAME_AND_VERSION));
            String strVersion = str.substring(str.indexOf(SPLIT_FOR_NAME_AND_VERSION) + SPLIT_FOR_NAME_AND_VERSION.length(), str.length());
            return new Feature(strName, strVersion);
        }
        return new Feature(str);
    }

    @Override
    public String getId() {
        return this.getName() + "-" + this.getVersion();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    @Override
    public String getVersion() {
        if (this.version == null) {
            return "0.0.0";
        }
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    @Override
    public boolean hasVersion() {
        return this.version != null;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    @Override
    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    @Override
    public String getResolver() {
        return this.resolver;
    }

    @Override
    public String getInstall() {
        return this.install;
    }

    public void setInstall(String install) {
        this.install = install;
    }

    public void setResolver(String value) {
        this.resolver = value;
    }

    @Override
    public int getStartLevel() {
        return this.startLevel == null ? 0 : this.startLevel;
    }

    public void setStartLevel(Integer value) {
        this.startLevel = value;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public List<Conditional> getConditional() {
        if (this.conditional == null) {
            this.conditional = new ArrayList<Conditional>();
        }
        return this.conditional;
    }

    public String toString() {
        String ret = this.getName() + SPLIT_FOR_NAME_AND_VERSION + this.getVersion();
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Feature feature = (Feature)o;
        if (this.name != null ? !this.name.equals(feature.name) : feature.name != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(feature.version) : feature.version != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    protected void interpolation(Properties properties) {
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = properties.getProperty(key);
            Matcher matcher = Pattern.compile("\\$\\{([^}]+)\\}").matcher(val);
            while (matcher.find()) {
                String rep = System.getProperty(matcher.group(1));
                if (rep == null) continue;
                val = val.replace(matcher.group(0), rep);
                matcher.reset(val);
            }
            properties.put(key, val);
        }
    }
}

