/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.application;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.application.ProcessApplicationRegistration;
import org.camunda.bpm.application.impl.ProcessApplicationLogger;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.application.DefaultProcessApplicationRegistration;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.TransactionState;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionManager;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentFailListener;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionManager;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class ProcessApplicationManager {
    public static final ProcessApplicationLogger LOG = ProcessEngineLogger.PROCESS_APPLICATION_LOGGER;
    protected Map<String, DefaultProcessApplicationRegistration> registrationsByDeploymentId = new HashMap<String, DefaultProcessApplicationRegistration>();

    public ProcessApplicationReference getProcessApplicationForDeployment(String deploymentId) {
        DefaultProcessApplicationRegistration registration = this.registrationsByDeploymentId.get(deploymentId);
        if (registration != null) {
            return registration.getReference();
        }
        return null;
    }

    public synchronized ProcessApplicationRegistration registerProcessApplicationForDeployments(Set<String> deploymentsToRegister, ProcessApplicationReference reference) {
        DefaultProcessApplicationRegistration registration = this.createProcessApplicationRegistration(deploymentsToRegister, reference);
        this.createJobExecutorRegistrations(deploymentsToRegister);
        this.logRegistration(deploymentsToRegister, reference);
        return registration;
    }

    public synchronized void unregisterProcessApplicationForDeployments(Set<String> deploymentIds, boolean removeProcessesFromCache) {
        this.removeJobExecutorRegistrations(deploymentIds);
        this.removeProcessApplicationRegistration(deploymentIds, removeProcessesFromCache);
    }

    protected DefaultProcessApplicationRegistration createProcessApplicationRegistration(Set<String> deploymentsToRegister, ProcessApplicationReference reference) {
        String processEngineName = Context.getProcessEngineConfiguration().getProcessEngineName();
        DefaultProcessApplicationRegistration registration = new DefaultProcessApplicationRegistration(reference, deploymentsToRegister, processEngineName);
        for (String deploymentId : deploymentsToRegister) {
            this.registrationsByDeploymentId.put(deploymentId, registration);
        }
        return registration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeProcessApplicationRegistration(Set<String> deploymentIds, boolean removeProcessesFromCache) {
        for (String deploymentId : deploymentIds) {
            try {
                if (!removeProcessesFromCache) continue;
                Context.getProcessEngineConfiguration().getDeploymentCache().removeDeployment(deploymentId);
            }
            catch (Throwable t) {
                LOG.couldNotRemoveDefinitionsFromCache(t);
            }
            finally {
                if (deploymentId == null) continue;
                this.registrationsByDeploymentId.remove(deploymentId);
            }
        }
    }

    protected void createJobExecutorRegistrations(Set<String> deploymentIds) {
        try {
            Context.getCommandContext().getTransactionContext().addTransactionListener(TransactionState.ROLLED_BACK, new DeploymentFailListener(deploymentIds));
            Set<String> registeredDeployments = Context.getProcessEngineConfiguration().getRegisteredDeployments();
            registeredDeployments.addAll(deploymentIds);
        }
        catch (Exception e) {
            throw LOG.exceptionWhileRegisteringDeploymentsWithJobExecutor(e);
        }
    }

    protected void removeJobExecutorRegistrations(Set<String> deploymentIds) {
        try {
            Set<String> registeredDeployments = Context.getProcessEngineConfiguration().getRegisteredDeployments();
            registeredDeployments.removeAll(deploymentIds);
        }
        catch (Exception e) {
            LOG.exceptionWhileUnregisteringDeploymentsWithJobExecutor(e);
        }
    }

    protected void logRegistration(Set<String> deploymentIds, ProcessApplicationReference reference) {
        if (LOG.isInfoEnabled()) {
            return;
        }
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("ProcessApplication '");
            builder.append(reference.getName());
            builder.append("' registered for DB deployments ");
            builder.append(deploymentIds);
            builder.append(". ");
            ArrayList<ProcessDefinition> processDefinitions = new ArrayList<ProcessDefinition>();
            ArrayList<CaseDefinition> caseDefinitions = new ArrayList<CaseDefinition>();
            CommandContext commandContext = Context.getCommandContext();
            ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
            boolean cmmnEnabled = processEngineConfiguration.isCmmnEnabled();
            for (String deploymentId : deploymentIds) {
                DeploymentEntity deployment = commandContext.getDbEntityManager().selectById(DeploymentEntity.class, deploymentId);
                if (deployment == null) continue;
                processDefinitions.addAll(this.getDeployedProcessDefinitionArtifacts(deployment));
                if (!cmmnEnabled) continue;
                caseDefinitions.addAll(this.getDeployedCaseDefinitionArtifacts(deployment));
            }
            this.logProcessDefinitionRegistrations(builder, processDefinitions);
            if (cmmnEnabled) {
                this.logCaseDefinitionRegistrations(builder, caseDefinitions);
            }
            LOG.registrationSummary(builder.toString());
        }
        catch (Throwable e) {
            LOG.exceptionWhileLoggingRegistrationSummary(e);
        }
    }

    protected List<ProcessDefinition> getDeployedProcessDefinitionArtifacts(DeploymentEntity deployment) {
        CommandContext commandContext = Context.getCommandContext();
        List<ProcessDefinitionEntity> entities = deployment.getDeployedArtifacts(ProcessDefinitionEntity.class);
        if (entities == null) {
            String deploymentId = deployment.getId();
            ProcessDefinitionManager manager = commandContext.getProcessDefinitionManager();
            return manager.findProcessDefinitionsByDeploymentId(deploymentId);
        }
        return new ArrayList<ProcessDefinition>(entities);
    }

    protected List<CaseDefinition> getDeployedCaseDefinitionArtifacts(DeploymentEntity deployment) {
        CommandContext commandContext = Context.getCommandContext();
        List<CaseDefinitionEntity> entities = deployment.getDeployedArtifacts(CaseDefinitionEntity.class);
        if (entities == null) {
            String deploymentId = deployment.getId();
            CaseDefinitionManager caseDefinitionManager = commandContext.getCaseDefinitionManager();
            return caseDefinitionManager.findCaseDefinitionByDeploymentId(deploymentId);
        }
        return new ArrayList<CaseDefinition>(entities);
    }

    protected void logProcessDefinitionRegistrations(StringBuilder builder, List<ProcessDefinition> processDefinitions) {
        if (processDefinitions.isEmpty()) {
            builder.append("Deployment does not provide any process definitions.");
        } else {
            builder.append("Will execute process definitions ");
            builder.append("\n");
            for (ProcessDefinition processDefinition : processDefinitions) {
                builder.append("\n");
                builder.append("        ");
                builder.append(processDefinition.getKey());
                builder.append("[version: ");
                builder.append(processDefinition.getVersion());
                builder.append(", id: ");
                builder.append(processDefinition.getId());
                builder.append("]");
            }
            builder.append("\n");
        }
    }

    protected void logCaseDefinitionRegistrations(StringBuilder builder, List<CaseDefinition> caseDefinitions) {
        if (caseDefinitions.isEmpty()) {
            builder.append("Deployment does not provide any case definitions.");
        } else {
            builder.append("\n");
            builder.append("Will execute case definitions ");
            builder.append("\n");
            for (CaseDefinition caseDefinition : caseDefinitions) {
                builder.append("\n");
                builder.append("        ");
                builder.append(caseDefinition.getKey());
                builder.append("[version: ");
                builder.append(caseDefinition.getVersion());
                builder.append(", id: ");
                builder.append(caseDefinition.getId());
                builder.append("]");
            }
            builder.append("\n");
        }
    }

    public String getRegistrationSummary() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, DefaultProcessApplicationRegistration> entry : this.registrationsByDeploymentId.entrySet()) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(entry.getKey());
            builder.append("->");
            builder.append(entry.getValue().getReference().getName());
        }
        return builder.toString();
    }
}

