/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.bpmn.behavior.BpmnBehaviorLogger;
import org.camunda.bpm.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;

public class SequentialMultiInstanceActivityBehavior
extends MultiInstanceActivityBehavior {
    protected static final BpmnBehaviorLogger LOG = ProcessEngineLogger.BPMN_BEHAVIOR_LOGGER;

    @Override
    protected void createInstances(ActivityExecution execution, int nrOfInstances) throws Exception {
        this.setLoopVariable(execution, "nrOfInstances", nrOfInstances);
        this.setLoopVariable(execution, "nrOfCompletedInstances", 0);
        this.setLoopVariable(execution, "nrOfActiveInstances", 1);
        ActivityImpl innerActivity = this.getInnerActivity(execution);
        this.performInstance(execution, innerActivity, 0);
    }

    @Override
    public void complete(ActivityExecution scopeExecution) {
        int loopCounter = this.getLoopVariable(scopeExecution, "loopCounter") + 1;
        int nrOfInstances = this.getLoopVariable(scopeExecution, "nrOfInstances");
        int nrOfCompletedInstances = this.getLoopVariable(scopeExecution, "nrOfCompletedInstances") + 1;
        this.setLoopVariable(scopeExecution, "nrOfCompletedInstances", nrOfCompletedInstances);
        if (loopCounter == nrOfInstances || this.completionConditionSatisfied(scopeExecution)) {
            this.leave(scopeExecution);
        } else {
            ActivityImpl innerActivity = this.getInnerActivity(scopeExecution);
            this.performInstance(scopeExecution, innerActivity, loopCounter);
        }
    }

    @Override
    public void concurrentChildExecutionEnded(ActivityExecution scopeExecution, ActivityExecution endedExecution) {
    }

    @Override
    public ActivityExecution initializeScope(ActivityExecution scopeExecution) {
        this.setLoopVariable(scopeExecution, "nrOfInstances", 1);
        this.setLoopVariable(scopeExecution, "nrOfCompletedInstances", 0);
        this.setLoopVariable(scopeExecution, "nrOfActiveInstances", 1);
        this.setLoopVariable(scopeExecution, "loopCounter", 0);
        return scopeExecution;
    }

    @Override
    public void concurrentExecutionCreated(ActivityExecution scopeExecution, ActivityExecution concurrentExecution) {
        throw LOG.unsupportedConcurrencyException(scopeExecution.toString(), this.getClass().getSimpleName());
    }

    @Override
    public void concurrentExecutionDeleted(ActivityExecution scopeExecution, ActivityExecution concurrentExecution) {
        throw LOG.unsupportedConcurrencyException(scopeExecution.toString(), this.getClass().getSimpleName());
    }
}

