/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class UnlockExternalTaskCmd
implements Command<Void> {
    protected String externalTaskId;

    public UnlockExternalTaskCmd(String externalTaskId) {
        this.externalTaskId = externalTaskId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        this.validateInput();
        ExternalTaskEntity externalTask = commandContext.getExternalTaskManager().findExternalTaskById(this.externalTaskId);
        EnsureUtil.ensureNotNull(NotFoundException.class, "Cannot find external task with id " + this.externalTaskId, "externalTask", (Object)externalTask);
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkUpdateProcessInstanceById(externalTask.getProcessInstanceId());
        externalTask.unlock();
        return null;
    }

    protected void validateInput() {
        EnsureUtil.ensureNotNull("externalTaskId", (Object)this.externalTaskId);
    }
}

