/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.core.variable.scope;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableInstance;
import org.camunda.bpm.engine.impl.core.variable.event.VariableEvent;
import org.camunda.bpm.engine.impl.core.variable.event.VariableEventDispatcher;
import org.camunda.bpm.engine.impl.core.variable.scope.CoreVariableStore;
import org.camunda.bpm.engine.impl.javax.el.ELContext;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.impl.VariableMapImpl;
import org.camunda.bpm.engine.variable.value.TypedValue;

public abstract class AbstractVariableScope
implements Serializable,
VariableScope,
VariableEventDispatcher {
    private static final long serialVersionUID = 1L;
    protected ELContext cachedElContext;

    protected abstract CoreVariableStore getVariableStore();

    public abstract AbstractVariableScope getParentVariableScope();

    @Override
    public String getVariableScopeKey() {
        return "scope";
    }

    public VariableMapImpl getVariables() {
        return this.getVariablesTyped();
    }

    public VariableMapImpl getVariablesTyped() {
        return this.getVariablesTyped(true);
    }

    public VariableMapImpl getVariablesTyped(boolean deserializeValues) {
        VariableMapImpl variableMap = new VariableMapImpl();
        this.collectVariables(variableMap, null, false, deserializeValues);
        return variableMap;
    }

    public VariableMapImpl getVariablesLocal() {
        return this.getVariablesLocalTyped();
    }

    public VariableMapImpl getVariablesLocalTyped() {
        return this.getVariablesLocalTyped(true);
    }

    public VariableMapImpl getVariablesLocalTyped(boolean deserializeObjectValues) {
        VariableMapImpl variables = new VariableMapImpl();
        this.collectVariables(variables, null, true, deserializeObjectValues);
        return variables;
    }

    public void collectVariables(VariableMapImpl resultVariables, Collection<String> variableNames, boolean isLocal, boolean deserializeValues) {
        AbstractVariableScope parentScope;
        boolean collectAll = variableNames == null;
        Map<String, CoreVariableInstance> localVariables = this.getVariableInstancesLocal();
        for (Map.Entry<String, CoreVariableInstance> var : localVariables.entrySet()) {
            if (resultVariables.containsKey((Object)var.getKey()) || !collectAll && !variableNames.contains(var.getKey())) continue;
            resultVariables.put(var.getKey(), (Object)var.getValue().getTypedValue(deserializeValues));
        }
        if (!(isLocal || (parentScope = this.getParentVariableScope()) == null || !collectAll && resultVariables.keySet().equals(variableNames))) {
            parentScope.collectVariables(resultVariables, variableNames, isLocal, deserializeValues);
        }
    }

    @Override
    public Object getVariable(String variableName) {
        return this.getVariable(variableName, true);
    }

    public Object getVariable(String variableName, boolean deserializeObjectValue) {
        return this.getValueFromVariableInstance(deserializeObjectValue, this.getVariableInstance(variableName));
    }

    @Override
    public Object getVariableLocal(String variableName) {
        return this.getVariableLocal(variableName, true);
    }

    public Object getVariableLocal(String variableName, boolean deserializeObjectValue) {
        return this.getValueFromVariableInstance(deserializeObjectValue, this.getVariableInstanceLocal(variableName));
    }

    protected Object getValueFromVariableInstance(boolean deserializeObjectValue, CoreVariableInstance variableInstance) {
        TypedValue typedValue;
        if (variableInstance != null && (typedValue = variableInstance.getTypedValue(deserializeObjectValue)) != null) {
            return typedValue.getValue();
        }
        return null;
    }

    @Override
    public <T extends TypedValue> T getVariableTyped(String variableName) {
        return this.getVariableTyped(variableName, true);
    }

    @Override
    public <T extends TypedValue> T getVariableTyped(String variableName, boolean deserializeValue) {
        return this.getTypedValueFromVariableInstance(deserializeValue, this.getVariableInstance(variableName));
    }

    @Override
    public <T extends TypedValue> T getVariableLocalTyped(String variableName) {
        return this.getVariableLocalTyped(variableName, true);
    }

    @Override
    public <T extends TypedValue> T getVariableLocalTyped(String variableName, boolean deserializeValue) {
        return this.getTypedValueFromVariableInstance(deserializeValue, this.getVariableInstanceLocal(variableName));
    }

    private <T extends TypedValue> T getTypedValueFromVariableInstance(boolean deserializeValue, CoreVariableInstance variableInstance) {
        if (variableInstance != null) {
            return (T)variableInstance.getTypedValue(deserializeValue);
        }
        return null;
    }

    public CoreVariableInstance getVariableInstance(String variableName) {
        CoreVariableInstance variableInstance = this.getVariableInstanceLocal(variableName);
        if (variableInstance != null) {
            return variableInstance;
        }
        AbstractVariableScope parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            return parentScope.getVariableInstance(variableName);
        }
        return null;
    }

    public CoreVariableInstance getVariableInstanceLocal(String name) {
        return this.getVariableStore().getVariableInstance(name);
    }

    public Map<String, CoreVariableInstance> getVariableInstancesLocal() {
        return this.getVariableStore().getVariableInstances();
    }

    @Override
    public boolean hasVariables() {
        if (!this.getVariableStore().isEmpty()) {
            return true;
        }
        AbstractVariableScope parentScope = this.getParentVariableScope();
        return parentScope != null && parentScope.hasVariables();
    }

    @Override
    public boolean hasVariablesLocal() {
        return !this.getVariableStore().isEmpty();
    }

    @Override
    public boolean hasVariable(String variableName) {
        if (this.hasVariableLocal(variableName)) {
            return true;
        }
        AbstractVariableScope parentScope = this.getParentVariableScope();
        return parentScope != null && parentScope.hasVariable(variableName);
    }

    @Override
    public boolean hasVariableLocal(String variableName) {
        return this.getVariableStore().containsVariableInstance(variableName);
    }

    protected Set<String> collectVariableNames(Set<String> variableNames) {
        AbstractVariableScope parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            variableNames.addAll(parentScope.collectVariableNames(variableNames));
        }
        for (CoreVariableInstance variableInstance : this.getVariableStore().getVariableInstancesValues()) {
            variableNames.add(variableInstance.getName());
        }
        return variableNames;
    }

    @Override
    public Set<String> getVariableNames() {
        return this.collectVariableNames(new HashSet<String>());
    }

    @Override
    public Set<String> getVariableNamesLocal() {
        return this.getVariableStore().getVariableNames();
    }

    @Override
    public void setVariables(Map<String, ? extends Object> variables) {
        if (variables != null) {
            for (String variableName : variables.keySet()) {
                Object value = null;
                value = variables instanceof VariableMap ? ((VariableMap)variables).getValueTyped(variableName) : variables.get(variableName);
                this.setVariable(variableName, value);
            }
        }
    }

    @Override
    public void setVariablesLocal(Map<String, ? extends Object> variables) {
        if (variables != null) {
            for (String variableName : variables.keySet()) {
                Object value = null;
                value = variables instanceof VariableMap ? ((VariableMap)variables).getValueTyped(variableName) : variables.get(variableName);
                this.setVariableLocal(variableName, value);
            }
        }
    }

    @Override
    public void removeVariables() {
        HashSet<String> variableNames = new HashSet<String>(this.getVariableStore().getVariableNames());
        for (String variableName : variableNames) {
            this.removeVariable(variableName);
        }
    }

    @Override
    public void removeVariablesLocal() {
        ArrayList<String> variableNames = new ArrayList<String>(this.getVariableNamesLocal());
        for (String variableName : variableNames) {
            this.removeVariableLocal(variableName);
        }
    }

    @Override
    public void removeVariables(Collection<String> variableNames) {
        if (variableNames != null) {
            for (String variableName : variableNames) {
                this.removeVariable(variableName);
            }
        }
    }

    @Override
    public void removeVariablesLocal(Collection<String> variableNames) {
        if (variableNames != null) {
            for (String variableName : variableNames) {
                this.removeVariableLocal(variableName);
            }
        }
    }

    @Override
    public void setVariable(String variableName, Object value) {
        TypedValue typedValue = Variables.untypedValue((Object)value);
        this.setVariable(variableName, typedValue, this.getSourceActivityVariableScope());
    }

    protected void setVariable(String variableName, TypedValue value, AbstractVariableScope sourceActivityVariableScope) {
        if (this.hasVariableLocal(variableName)) {
            this.setVariableLocal(variableName, value, sourceActivityVariableScope);
            return;
        }
        AbstractVariableScope parentVariableScope = this.getParentVariableScope();
        if (parentVariableScope != null) {
            if (sourceActivityVariableScope == null) {
                parentVariableScope.setVariable(variableName, value);
            } else {
                parentVariableScope.setVariable(variableName, value, sourceActivityVariableScope);
            }
            return;
        }
        this.setVariableLocal(variableName, value, sourceActivityVariableScope);
    }

    public void setVariableLocal(String variableName, TypedValue value, AbstractVariableScope sourceActivityExecution) {
        this.getVariableStore().createOrUpdateVariable(variableName, value, sourceActivityExecution);
    }

    @Override
    public void setVariableLocal(String variableName, Object value) {
        TypedValue typedValue = Variables.untypedValue((Object)value);
        this.getVariableStore().createOrUpdateVariable(variableName, typedValue, this.getSourceActivityVariableScope());
    }

    public void setVariableLocalTransient(String variableName, Object value) {
        TypedValue typedValue = Variables.untypedValue((Object)value);
        this.getVariableStore().createTransientVariable(variableName, typedValue, this.getSourceActivityVariableScope());
    }

    @Override
    public void removeVariable(String variableName) {
        this.removeVariable(variableName, this.getSourceActivityVariableScope());
    }

    protected void removeVariable(String variableName, AbstractVariableScope sourceActivityExecution) {
        if (this.getVariableStore().containsVariableInstance(variableName)) {
            this.removeVariableLocal(variableName);
            return;
        }
        AbstractVariableScope parentVariableScope = this.getParentVariableScope();
        if (parentVariableScope != null) {
            if (sourceActivityExecution == null) {
                parentVariableScope.removeVariable(variableName);
            } else {
                parentVariableScope.removeVariable(variableName, sourceActivityExecution);
            }
        }
    }

    @Override
    public void removeVariableLocal(String variableName) {
        this.removeVariableLocal(variableName, this.getSourceActivityVariableScope());
    }

    protected AbstractVariableScope getSourceActivityVariableScope() {
        return this;
    }

    protected void removeVariableLocal(String variableName, AbstractVariableScope sourceActivityExecution) {
        this.getVariableStore().removeVariableInstance(variableName, sourceActivityExecution);
    }

    public ELContext getCachedElContext() {
        return this.cachedElContext;
    }

    public void setCachedElContext(ELContext cachedElContext) {
        this.cachedElContext = cachedElContext;
    }

    @Override
    public void dispatchEvent(VariableEvent variableEvent) {
    }
}

