/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.dmn.cmd;

import java.util.Map;
import org.camunda.bpm.dmn.engine.DmnDecisionTableResult;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.util.DecisionTableUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;

public class EvaluateDecisionByKeyCmd
implements Command<DmnDecisionTableResult> {
    protected String decisionDefinitionKey;
    protected Integer version;
    protected VariableMap variables;

    public EvaluateDecisionByKeyCmd(String decisionDefinitionKey, Integer version, Map<String, Object> variables) {
        this.decisionDefinitionKey = decisionDefinitionKey;
        this.version = version;
        this.variables = Variables.fromMap(variables);
    }

    public EvaluateDecisionByKeyCmd(String decisionDefinitionKey, Map<String, Object> variables) {
        this(decisionDefinitionKey, null, variables);
    }

    @Override
    public DmnDecisionTableResult execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("decision definition key is null", "processDefinitionKey", (Object)this.decisionDefinitionKey);
        DecisionDefinition decisionDefinition = this.getDecisionDefinition(commandContext);
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkEvaluateDecision(decisionDefinition.getKey());
        return this.doEvaluateDecision(decisionDefinition, this.variables);
    }

    protected DmnDecisionTableResult doEvaluateDecision(DecisionDefinition decisionDefinition, VariableMap variables) {
        try {
            return DecisionTableUtil.evaluateDecisionTable(decisionDefinition, variables);
        }
        catch (Exception e) {
            throw new ProcessEngineException("Exception while evaluating decision with key '" + this.decisionDefinitionKey + "'", e);
        }
    }

    protected DecisionDefinition getDecisionDefinition(CommandContext commandContext) {
        DeploymentCache deploymentCache = commandContext.getProcessEngineConfiguration().getDeploymentCache();
        if (this.version == null) {
            return deploymentCache.findDeployedLatestDecisionDefinitionByKey(this.decisionDefinitionKey);
        }
        return deploymentCache.findDeployedDecisionDefinitionByKeyAndVersion(this.decisionDefinitionKey, this.version);
    }
}

