/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.impl.AbstractVariableQueryImpl;
import org.camunda.bpm.engine.impl.EventSubscriptionQueryValue;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.ProcessInstanceQueryProperty;
import org.camunda.bpm.engine.impl.QueryOrderingProperty;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;

public class ProcessInstanceQueryImpl
extends AbstractVariableQueryImpl<ProcessInstanceQuery, ProcessInstance>
implements ProcessInstanceQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected String businessKey;
    protected String processDefinitionId;
    protected Set<String> processInstanceIds;
    protected String processDefinitionKey;
    protected String deploymentId;
    protected String superProcessInstanceId;
    protected String subProcessInstanceId;
    protected SuspensionState suspensionState;
    protected String incidentType;
    protected String incidentId;
    protected String incidentMessage;
    protected String incidentMessageLike;
    protected String caseInstanceId;
    protected String superCaseInstanceId;
    protected String subCaseInstanceId;
    protected String activityId;
    protected List<EventSubscriptionQueryValue> eventSubscriptions;

    public ProcessInstanceQueryImpl() {
    }

    public ProcessInstanceQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public ProcessInstanceQueryImpl processInstanceId(String processInstanceId) {
        EnsureUtil.ensureNotNull("Process instance id", (Object)processInstanceId);
        this.executionId = processInstanceId;
        return this;
    }

    @Override
    public ProcessInstanceQuery processInstanceIds(Set<String> processInstanceIds) {
        EnsureUtil.ensureNotEmpty("Set of process instance ids", processInstanceIds);
        this.processInstanceIds = processInstanceIds;
        return this;
    }

    @Override
    public ProcessInstanceQuery processInstanceBusinessKey(String businessKey) {
        EnsureUtil.ensureNotNull("Business key", (Object)businessKey);
        this.businessKey = businessKey;
        return this;
    }

    @Override
    public ProcessInstanceQuery processInstanceBusinessKey(String businessKey, String processDefinitionKey) {
        EnsureUtil.ensureNotNull("Business key", (Object)businessKey);
        this.businessKey = businessKey;
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public ProcessInstanceQueryImpl processDefinitionId(String processDefinitionId) {
        EnsureUtil.ensureNotNull("Process definition id", (Object)processDefinitionId);
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public ProcessInstanceQueryImpl processDefinitionKey(String processDefinitionKey) {
        EnsureUtil.ensureNotNull("Process definition key", (Object)processDefinitionKey);
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public ProcessInstanceQuery deploymentId(String deploymentId) {
        EnsureUtil.ensureNotNull("Deployment id", (Object)deploymentId);
        this.deploymentId = deploymentId;
        return this;
    }

    @Override
    public ProcessInstanceQuery superProcessInstanceId(String superProcessInstanceId) {
        this.superProcessInstanceId = superProcessInstanceId;
        return this;
    }

    @Override
    public ProcessInstanceQuery subProcessInstanceId(String subProcessInstanceId) {
        this.subProcessInstanceId = subProcessInstanceId;
        return this;
    }

    @Override
    public ProcessInstanceQuery caseInstanceId(String caseInstanceId) {
        EnsureUtil.ensureNotNull("caseInstanceId", (Object)caseInstanceId);
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    @Override
    public ProcessInstanceQuery superCaseInstanceId(String superCaseInstanceId) {
        EnsureUtil.ensureNotNull("superCaseInstanceId", (Object)superCaseInstanceId);
        this.superCaseInstanceId = superCaseInstanceId;
        return this;
    }

    @Override
    public ProcessInstanceQuery subCaseInstanceId(String subCaseInstanceId) {
        EnsureUtil.ensureNotNull("subCaseInstanceId", (Object)subCaseInstanceId);
        this.subCaseInstanceId = subCaseInstanceId;
        return this;
    }

    @Override
    public ProcessInstanceQuery orderByProcessInstanceId() {
        this.orderBy(ProcessInstanceQueryProperty.PROCESS_INSTANCE_ID);
        return this;
    }

    @Override
    public ProcessInstanceQuery orderByProcessDefinitionId() {
        this.orderBy(new QueryOrderingProperty("process-definition", ProcessInstanceQueryProperty.PROCESS_DEFINITION_ID));
        return this;
    }

    @Override
    public ProcessInstanceQuery orderByProcessDefinitionKey() {
        this.orderBy(new QueryOrderingProperty("process-definition", ProcessInstanceQueryProperty.PROCESS_DEFINITION_KEY));
        return this;
    }

    @Override
    public ProcessInstanceQuery active() {
        this.suspensionState = SuspensionState.ACTIVE;
        return this;
    }

    @Override
    public ProcessInstanceQuery suspended() {
        this.suspensionState = SuspensionState.SUSPENDED;
        return this;
    }

    @Override
    public ProcessInstanceQuery incidentType(String incidentType) {
        EnsureUtil.ensureNotNull("incident type", (Object)incidentType);
        this.incidentType = incidentType;
        return this;
    }

    @Override
    public ProcessInstanceQuery incidentId(String incidentId) {
        EnsureUtil.ensureNotNull("incident id", (Object)incidentId);
        this.incidentId = incidentId;
        return this;
    }

    @Override
    public ProcessInstanceQuery incidentMessage(String incidentMessage) {
        EnsureUtil.ensureNotNull("incident message", (Object)incidentMessage);
        this.incidentMessage = incidentMessage;
        return this;
    }

    @Override
    public ProcessInstanceQuery incidentMessageLike(String incidentMessageLike) {
        EnsureUtil.ensureNotNull("incident messageLike", (Object)incidentMessageLike);
        this.incidentMessageLike = incidentMessageLike;
        return this;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        return commandContext.getExecutionManager().findProcessInstanceCountByQueryCriteria(this);
    }

    @Override
    public List<ProcessInstance> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        return commandContext.getExecutionManager().findProcessInstanceByQueryCriteria(this, page);
    }

    public boolean getOnlyProcessInstances() {
        return true;
    }

    public String getProcessInstanceId() {
        return this.executionId;
    }

    public Set<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getActivityId() {
        return null;
    }

    public String getSuperProcessInstanceId() {
        return this.superProcessInstanceId;
    }

    public String getSubProcessInstanceId() {
        return this.subProcessInstanceId;
    }

    public SuspensionState getSuspensionState() {
        return this.suspensionState;
    }

    public void setSuspensionState(SuspensionState suspensionState) {
        this.suspensionState = suspensionState;
    }

    public List<EventSubscriptionQueryValue> getEventSubscriptions() {
        return this.eventSubscriptions;
    }

    public void setEventSubscriptions(List<EventSubscriptionQueryValue> eventSubscriptions) {
        this.eventSubscriptions = eventSubscriptions;
    }

    public String getIncidentId() {
        return this.incidentId;
    }

    public String getIncidentType() {
        return this.incidentType;
    }

    public String getIncidentMessage() {
        return this.incidentMessage;
    }

    public String getIncidentMessageLike() {
        return this.incidentMessageLike;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public String getSuperCaseInstanceId() {
        return this.superCaseInstanceId;
    }

    public String getSubCaseInstanceId() {
        return this.subCaseInstanceId;
    }
}

