/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.List;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.BpmnBehaviorLogger;
import org.camunda.bpm.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmProcessInstance;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class IntermediateThrowSignalEventActivityBehavior
extends AbstractBpmnActivityBehavior {
    protected static final BpmnBehaviorLogger LOG = ProcessEngineLogger.BPMN_BEHAVIOR_LOGGER;
    protected final EventSubscriptionDeclaration signalDefinition;

    public IntermediateThrowSignalEventActivityBehavior(EventSubscriptionDeclaration signalDefinition) {
        this.signalDefinition = signalDefinition;
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        EventSubscriptionManager eventSubscriptionManager = Context.getCommandContext().getEventSubscriptionManager();
        List<SignalEventSubscriptionEntity> catchSignalEventSubscription = eventSubscriptionManager.findSignalEventSubscriptionsByEventName(this.signalDefinition.getEventName());
        for (SignalEventSubscriptionEntity signalEventSubscriptionEntity : catchSignalEventSubscription) {
            if (!this.isActiveEventSubscription(signalEventSubscriptionEntity)) continue;
            signalEventSubscriptionEntity.eventReceived(null, this.signalDefinition.isAsync());
        }
        this.leave(execution);
    }

    protected boolean isActiveEventSubscription(SignalEventSubscriptionEntity signalEventSubscriptionEntity) {
        return this.isStartEventSubscription(signalEventSubscriptionEntity) || this.isActiveIntermediateEventSubscription(signalEventSubscriptionEntity);
    }

    protected boolean isStartEventSubscription(SignalEventSubscriptionEntity signalEventSubscriptionEntity) {
        return signalEventSubscriptionEntity.getExecutionId() == null;
    }

    protected boolean isActiveIntermediateEventSubscription(SignalEventSubscriptionEntity signalEventSubscriptionEntity) {
        ExecutionEntity execution = signalEventSubscriptionEntity.getExecution();
        return execution != null && !execution.isEnded() && !execution.isCanceled();
    }

    protected void startProcessInstanceBySignal(SignalEventSubscriptionEntity eventSubscription) {
        String processDefinitionId = eventSubscription.getConfiguration();
        EnsureUtil.ensureNotNull("Configuration of signal start event subscription '" + eventSubscription.getId() + "' contains no process definition id.", (Object)processDefinitionId);
        DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
        ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedProcessDefinitionById(processDefinitionId);
        if (processDefinition == null || processDefinition.isSuspended()) {
            LOG.ignoringEventSubscription(eventSubscription, processDefinitionId);
        } else {
            ActivityImpl signalStartEvent = processDefinition.findActivity(eventSubscription.getActivityId());
            PvmProcessInstance processInstance = processDefinition.createProcessInstanceForInitial(signalStartEvent);
            processInstance.start();
        }
    }
}

