/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class HandleExternalTaskFailureCmd
implements Command<Void> {
    protected String externalTaskId;
    protected String workerId;
    protected String errorMessage;
    protected long retryDuration;
    protected int retries;

    public HandleExternalTaskFailureCmd(String externalTaskId, String workerId, String errorMessage, int retries, long retryDuration) {
        this.externalTaskId = externalTaskId;
        this.workerId = workerId;
        this.errorMessage = errorMessage;
        this.retries = retries;
        this.retryDuration = retryDuration;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        this.validateInput();
        ExternalTaskEntity externalTask = commandContext.getExternalTaskManager().findExternalTaskById(this.externalTaskId);
        EnsureUtil.ensureNotNull(NotFoundException.class, "Cannot find external task with id " + this.externalTaskId, "externalTask", (Object)externalTask);
        if (!this.workerId.equals(externalTask.getWorkerId())) {
            throw new BadUserRequestException("Failure of External Task " + this.externalTaskId + " cannot be reported by worker '" + this.workerId + "'. It is locked by worker '" + externalTask.getWorkerId() + "'.");
        }
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkUpdateProcessInstanceById(externalTask.getProcessInstanceId());
        externalTask.failed(this.errorMessage, this.retries, this.retryDuration);
        return null;
    }

    protected void validateInput() {
        EnsureUtil.ensureNotNull("externalTaskId", (Object)this.externalTaskId);
        EnsureUtil.ensureNotNull("workerId", (Object)this.workerId);
        EnsureUtil.ensureGreaterThanOrEqual("retries", this.retries, 0L);
        EnsureUtil.ensureGreaterThanOrEqual("retryDuration", this.retryDuration, 0L);
    }
}

