/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.impl.cfg.TransactionContext;
import org.camunda.bpm.engine.impl.cfg.TransactionState;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.MessageAddedNotification;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.JobExceptionUtil;

public abstract class JobRetryCmd
implements Command<Object> {
    protected static final long serialVersionUID = 1L;
    protected String jobId;
    protected Throwable exception;

    public JobRetryCmd(String jobId, Throwable exception) {
        this.jobId = jobId;
        this.exception = exception;
    }

    protected JobEntity getJob() {
        return Context.getCommandContext().getJobManager().findJobById(this.jobId);
    }

    protected void unlockJob(JobEntity job) {
        job.setLockOwner(null);
        job.setLockExpirationTime(null);
    }

    protected void logException(JobEntity job) {
        if (this.exception != null) {
            job.setExceptionMessage(this.exception.getMessage());
            job.setExceptionStacktrace(this.getExceptionStacktrace());
        }
    }

    protected void decrementRetries(JobEntity job) {
        if (this.exception == null || this.shouldDecrementRetriesFor(this.exception)) {
            job.setRetries(job.getRetries() - 1);
        }
    }

    protected String getExceptionStacktrace() {
        return JobExceptionUtil.getJobExceptionStacktrace(this.exception);
    }

    protected boolean shouldDecrementRetriesFor(Throwable t) {
        return !(t instanceof OptimisticLockingException);
    }

    protected void notifyAcquisition(CommandContext commandContext) {
        JobExecutor jobExecutor = Context.getProcessEngineConfiguration().getJobExecutor();
        MessageAddedNotification messageAddedNotification = new MessageAddedNotification(jobExecutor);
        TransactionContext transactionContext = commandContext.getTransactionContext();
        transactionContext.addTransactionListener(TransactionState.COMMITTED, messageAddedNotification);
    }
}

