/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskManager;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class SetTaskPriorityCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int priority;
    protected String taskId;

    public SetTaskPriorityCmd(String taskId, int priority) {
        this.taskId = taskId;
        this.priority = priority;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("taskId", (Object)this.taskId);
        TaskManager taskManager = commandContext.getTaskManager();
        TaskEntity task = taskManager.findTaskById(this.taskId);
        EnsureUtil.ensureNotNull("Cannot find task with id " + this.taskId, "task", (Object)task);
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkUpdateTask(task);
        task.setPriority(this.priority);
        task.createHistoricTaskDetails("SetPriority");
        return null;
    }
}

