/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.externaltask;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.externaltask.ExternalTaskQueryBuilder;
import org.camunda.bpm.engine.externaltask.ExternalTaskQueryTopicBuilder;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.impl.cmd.FetchExternalTasksCmd;
import org.camunda.bpm.engine.impl.externaltask.ExternalTaskQueryTopicBuilderImpl;
import org.camunda.bpm.engine.impl.externaltask.TopicFetchInstruction;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;

public class ExternalTaskQueryBuilderImpl
implements ExternalTaskQueryBuilder {
    protected CommandExecutor commandExecutor;
    protected String workerId;
    protected int maxTasks;
    protected Map<String, TopicFetchInstruction> instructions;

    public ExternalTaskQueryBuilderImpl(CommandExecutor commandExecutor, String workerId, int maxTasks) {
        this.commandExecutor = commandExecutor;
        this.workerId = workerId;
        this.maxTasks = maxTasks;
        this.instructions = new HashMap<String, TopicFetchInstruction>();
    }

    @Override
    public ExternalTaskQueryTopicBuilder topic(String topicName, long lockDuration) {
        return new ExternalTaskQueryTopicBuilderImpl(this, topicName, lockDuration);
    }

    @Override
    public List<LockedExternalTask> execute() {
        return this.commandExecutor.execute(new FetchExternalTasksCmd(this.workerId, this.maxTasks, this.instructions));
    }

    public void addInstruction(TopicFetchInstruction instruction) {
        this.instructions.put(instruction.getTopicName(), instruction);
    }
}

