/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import java.util.Date;
import org.camunda.bpm.engine.impl.cfg.TransactionListener;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.TimerEventJobHandler;
import org.camunda.bpm.engine.impl.persistence.entity.TimerEntity;

public class RepeatingFailedJobListener
implements TransactionListener {
    protected CommandExecutor commandExecutor;
    protected String jobId;

    public RepeatingFailedJobListener(CommandExecutor commandExecutor, String jobId) {
        this.commandExecutor = commandExecutor;
        this.jobId = jobId;
    }

    @Override
    public void execute(CommandContext commandContext) {
        CreateNewTimerJobCommand cmd = new CreateNewTimerJobCommand(this.jobId);
        this.commandExecutor.execute(cmd);
    }

    protected class CreateNewTimerJobCommand
    implements Command<Void> {
        protected String jobId;

        public CreateNewTimerJobCommand(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public Void execute(CommandContext commandContext) {
            TimerEntity failedJob = (TimerEntity)commandContext.getJobManager().findJobById(this.jobId);
            Date newDueDate = failedJob.calculateRepeat();
            if (newDueDate != null) {
                failedJob.createNewTimerJob(newDueDate);
                String config = failedJob.getJobHandlerConfiguration();
                config = TimerEventJobHandler.createJobHandlerConfigurationWithFollowUpJobCreated(config);
                failedJob.setJobHandlerConfiguration(config);
            }
            return null;
        }
    }
}

