/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.calendar.BusinessCalendar;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.el.StartProcessVariableScope;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.jobexecutor.TimerDeclarationType;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TimerEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;

public class TimerDeclarationImpl
extends JobDeclaration<ExecutionEntity, TimerEntity> {
    private static final long serialVersionUID = 1L;
    protected Expression description;
    protected TimerDeclarationType type;
    protected String repeat;
    protected boolean isInterruptingTimer;
    protected String eventScopeActivityId = null;
    protected Boolean isParallelMultiInstance;

    public TimerDeclarationImpl(Expression expression, TimerDeclarationType type, String jobHandlerType) {
        super(jobHandlerType);
        this.description = expression;
        this.type = type;
    }

    public boolean isInterruptingTimer() {
        return this.isInterruptingTimer;
    }

    public void setInterruptingTimer(boolean isInterruptingTimer) {
        this.isInterruptingTimer = isInterruptingTimer;
    }

    public String getRepeat() {
        return this.repeat;
    }

    public void setEventScopeActivityId(String eventScopeActivityId) {
        this.eventScopeActivityId = eventScopeActivityId;
    }

    public String getEventScopeActivityId() {
        return this.eventScopeActivityId;
    }

    @Override
    protected TimerEntity newJobInstance(ExecutionEntity execution) {
        TimerEntity timer = new TimerEntity(this);
        if (execution != null) {
            timer.setExecution(execution);
        }
        return timer;
    }

    @Override
    protected void postInitialize(ExecutionEntity context, TimerEntity job) {
        Object dueDateValue;
        BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(this.type.calendarName);
        if (this.description == null) {
            throw new ProcessEngineException("Timer '" + context.getActivityId() + "' was not configured with a valid duration/time");
        }
        String dueDateString = null;
        Date duedate = null;
        VariableScope scopeForExpression = context;
        if (scopeForExpression == null) {
            scopeForExpression = StartProcessVariableScope.getSharedInstance();
        }
        if ((dueDateValue = this.description.getValue(scopeForExpression)) instanceof String) {
            dueDateString = (String)dueDateValue;
        } else if (dueDateValue instanceof Date) {
            duedate = (Date)dueDateValue;
        } else {
            throw new ProcessEngineException("Timer '" + context.getActivityId() + "' was not configured with a valid duration/time, either hand in a java.util.Date or a String in format 'yyyy-MM-dd'T'hh:mm:ss'");
        }
        if (duedate == null) {
            duedate = businessCalendar.resolveDuedate(dueDateString);
        }
        job.setDuedate(duedate);
        if (this.type == TimerDeclarationType.CYCLE && this.jobHandlerType != "timer-intermediate-transition" && !this.isInterruptingTimer) {
            String prepared = this.prepareRepeat(dueDateString);
            job.setRepeat(prepared);
        }
    }

    protected String prepareRepeat(String dueDate) {
        if (dueDate.startsWith("R") && dueDate.split("/").length == 2) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            return dueDate.replace("/", "/" + sdf.format(ClockUtil.getCurrentTime()) + "/");
        }
        return dueDate;
    }

    public TimerEntity createTimerInstance(ExecutionEntity execution) {
        return this.createTimer(execution);
    }

    public TimerEntity createStartTimerInstance(String deploymentId) {
        return this.createTimer(deploymentId);
    }

    public TimerEntity createTimer(String deploymentId) {
        TimerEntity timer = (TimerEntity)super.createJobInstance(null);
        timer.setDeploymentId(deploymentId);
        this.scheduleTimer(timer);
        return timer;
    }

    public TimerEntity createTimer(ExecutionEntity execution) {
        TimerEntity timer = (TimerEntity)super.createJobInstance(execution);
        this.scheduleTimer(timer);
        return timer;
    }

    protected void scheduleTimer(TimerEntity timer) {
        Context.getCommandContext().getJobManager().schedule(timer);
    }

    @Override
    protected ExecutionEntity resolveExecution(ExecutionEntity context) {
        return context;
    }
}

