/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.impl.EventSubscriptionQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.commons.utils.EnsureUtil;

public class EventSubscriptionManager
extends AbstractManager {
    protected List<SignalEventSubscriptionEntity> createdSignalSubscriptions = new ArrayList<SignalEventSubscriptionEntity>();

    public void insert(EventSubscriptionEntity persistentObject) {
        super.insert(persistentObject);
        if (persistentObject instanceof SignalEventSubscriptionEntity) {
            this.createdSignalSubscriptions.add((SignalEventSubscriptionEntity)persistentObject);
        }
    }

    public void deleteEventSubscription(EventSubscriptionEntity persistentObject) {
        this.getDbEntityManager().delete(persistentObject);
        if (persistentObject instanceof SignalEventSubscriptionEntity) {
            this.createdSignalSubscriptions.remove(persistentObject);
        }
        List<JobEntity> asyncJobs = this.getJobManager().findJobsByConfiguration("event", persistentObject.getId());
        for (JobEntity asyncJob : asyncJobs) {
            asyncJob.delete();
        }
    }

    public void deleteAndFlushEventSubscription(EventSubscriptionEntity persistentObject) {
        this.deleteEventSubscription(persistentObject);
        this.getDbEntityManager().flushEntity(persistentObject);
    }

    public EventSubscriptionEntity findEventSubscriptionbyId(String id) {
        return (EventSubscriptionEntity)this.getDbEntityManager().selectOne("selectEventSubscription", id);
    }

    public long findEventSubscriptionCountByQueryCriteria(EventSubscriptionQueryImpl eventSubscriptionQueryImpl) {
        this.configureAuthorizationCheck(eventSubscriptionQueryImpl);
        return (Long)this.getDbEntityManager().selectOne("selectEventSubscriptionCountByQueryCriteria", eventSubscriptionQueryImpl);
    }

    public List<EventSubscription> findEventSubscriptionsByQueryCriteria(EventSubscriptionQueryImpl eventSubscriptionQueryImpl, Page page) {
        this.configureAuthorizationCheck(eventSubscriptionQueryImpl);
        return this.getDbEntityManager().selectList("selectEventSubscriptionByQueryCriteria", eventSubscriptionQueryImpl, page);
    }

    public List<SignalEventSubscriptionEntity> findSignalEventSubscriptionsByEventName(String eventName) {
        String query = "selectSignalEventSubscriptionsByEventName";
        HashSet<SignalEventSubscriptionEntity> selectList = new HashSet<SignalEventSubscriptionEntity>(this.getDbEntityManager().selectList("selectSignalEventSubscriptionsByEventName", eventName));
        for (SignalEventSubscriptionEntity entity : this.createdSignalSubscriptions) {
            if (!eventName.equals(entity.getEventName())) continue;
            selectList.add(entity);
        }
        return new ArrayList<SignalEventSubscriptionEntity>(selectList);
    }

    public List<SignalEventSubscriptionEntity> findSignalEventSubscriptionsByExecution(String executionId) {
        String query = "selectSignalEventSubscriptionsByExecution";
        HashSet<SignalEventSubscriptionEntity> selectList = new HashSet<SignalEventSubscriptionEntity>(this.getDbEntityManager().selectList("selectSignalEventSubscriptionsByExecution", executionId));
        for (SignalEventSubscriptionEntity entity : this.createdSignalSubscriptions) {
            if (!executionId.equals(entity.getExecutionId())) continue;
            selectList.add(entity);
        }
        return new ArrayList<SignalEventSubscriptionEntity>(selectList);
    }

    public List<SignalEventSubscriptionEntity> findSignalEventSubscriptionsByNameAndExecution(String name, String executionId) {
        String query = "selectSignalEventSubscriptionsByNameAndExecution";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("executionId", executionId);
        params.put("eventName", name);
        HashSet<SignalEventSubscriptionEntity> selectList = new HashSet<SignalEventSubscriptionEntity>(this.getDbEntityManager().selectList("selectSignalEventSubscriptionsByNameAndExecution", params));
        for (SignalEventSubscriptionEntity entity : this.createdSignalSubscriptions) {
            if (!executionId.equals(entity.getExecutionId()) || !name.equals(entity.getEventName())) continue;
            selectList.add(entity);
        }
        return new ArrayList<SignalEventSubscriptionEntity>(selectList);
    }

    public List<EventSubscriptionEntity> findEventSubscriptionsByExecutionAndType(String executionId, String type, boolean lockResult) {
        String query = "selectEventSubscriptionsByExecutionAndType";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("executionId", executionId);
        params.put("eventType", type);
        params.put("lockResult", lockResult);
        return this.getDbEntityManager().selectList("selectEventSubscriptionsByExecutionAndType", params);
    }

    public List<EventSubscriptionEntity> findEventSubscriptionsByExecution(String executionId) {
        String query = "selectEventSubscriptionsByExecution";
        return this.getDbEntityManager().selectList("selectEventSubscriptionsByExecution", executionId);
    }

    public List<EventSubscriptionEntity> findEventSubscriptions(String executionId, String type, String activityId) {
        String query = "selectEventSubscriptionsByExecutionTypeAndActivity";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("executionId", executionId);
        params.put("eventType", type);
        params.put("activityId", activityId);
        return this.getDbEntityManager().selectList("selectEventSubscriptionsByExecutionTypeAndActivity", params);
    }

    public List<EventSubscriptionEntity> findEventSubscriptionsByConfiguration(String type, String configuration) {
        String query = "selectEventSubscriptionsByConfiguration";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("eventType", type);
        params.put("configuration", configuration);
        return this.getDbEntityManager().selectList("selectEventSubscriptionsByConfiguration", params);
    }

    public List<EventSubscriptionEntity> findEventSubscriptionsByName(String type, String eventName) {
        String query = "selectEventSubscriptionsByName";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("eventType", type);
        params.put("eventName", eventName);
        return this.getDbEntityManager().selectList("selectEventSubscriptionsByName", params);
    }

    public List<EventSubscriptionEntity> findEventSubscriptionsByNameAndExecution(String type, String eventName, String executionId, boolean lockResult) {
        ExecutionEntity cachedExecution = this.getDbEntityManager().getCachedEntity(ExecutionEntity.class, executionId);
        if (cachedExecution != null && !lockResult) {
            List<EventSubscriptionEntity> eventSubscriptions = cachedExecution.getEventSubscriptions();
            ArrayList<EventSubscriptionEntity> result = new ArrayList<EventSubscriptionEntity>();
            for (EventSubscriptionEntity subscription : eventSubscriptions) {
                if (!this.matchesSubscription(subscription, type, eventName)) continue;
                result.add(subscription);
            }
            return result;
        }
        String query = "selectEventSubscriptionsByNameAndExecution";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("eventType", type);
        params.put("eventName", eventName);
        params.put("executionId", executionId);
        params.put("lockResult", lockResult);
        return this.getDbEntityManager().selectList("selectEventSubscriptionsByNameAndExecution", params);
    }

    public MessageEventSubscriptionEntity findMessageStartEventSubscriptionByName(String messageName) {
        MessageEventSubscriptionEntity entity = (MessageEventSubscriptionEntity)this.getDbEntityManager().selectOne("selectMessageStartEventSubscriptionByName", messageName);
        return entity;
    }

    protected void configureAuthorizationCheck(EventSubscriptionQueryImpl query) {
        this.getAuthorizationManager().configureEventSubscriptionQuery(query);
    }

    protected boolean matchesSubscription(EventSubscriptionEntity subscription, String type, String eventName) {
        EnsureUtil.ensureNotNull((String)"event type", (Object)type);
        String subscriptionEventName = subscription.getEventName();
        return type.equals(subscription.getEventType()) && (eventName == null && subscriptionEventName == null || eventName != null && eventName.equals(subscriptionEventName));
    }
}

