/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.HashMap;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.HasDbRevision;

public class UserEntity
implements User,
Serializable,
DbEntity,
HasDbRevision {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected int revision;
    protected String firstName;
    protected String lastName;
    protected String email;
    protected String password;
    protected String newPassword;

    public UserEntity() {
    }

    public UserEntity(String id) {
        this.id = id;
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, String> persistentState = new HashMap<String, String>();
        persistentState.put("firstName", this.firstName);
        persistentState.put("lastName", this.lastName);
        persistentState.put("email", this.email);
        persistentState.put("password", this.password);
        return persistentState;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.newPassword = password;
    }

    public void setDbPassword(String password) {
        this.password = password;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    public void encryptPassword() {
        if (this.newPassword != null) {
            this.setDbPassword(this.encryptPassword(this.newPassword));
        }
    }

    protected String encryptPassword(String password) {
        if (password == null) {
            return null;
        }
        return Context.getProcessEngineConfiguration().getPasswordEncryptor().encrypt(password);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", revision=" + this.revision + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", email=" + this.email + ", password=" + this.password + "]";
    }
}

