/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.process;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.impl.core.model.CoreActivity;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.PvmException;
import org.camunda.bpm.engine.impl.pvm.PvmScope;
import org.camunda.bpm.engine.impl.pvm.PvmTransition;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;

public abstract class ScopeImpl
extends CoreActivity
implements PvmScope {
    private static final long serialVersionUID = 1L;
    protected boolean isSubProcessScope = false;
    protected List<ActivityImpl> flowActivities = new ArrayList<ActivityImpl>();
    protected Map<String, ActivityImpl> namedFlowActivities = new HashMap<String, ActivityImpl>();
    protected ProcessDefinitionImpl processDefinition;

    public ScopeImpl(String id, ProcessDefinitionImpl processDefinition) {
        super(id);
        this.processDefinition = processDefinition;
    }

    @Override
    public ActivityImpl findActivity(String activityId) {
        return (ActivityImpl)super.findActivity(activityId);
    }

    @Override
    public TransitionImpl findTransition(String transitionId) {
        for (PvmActivity pvmActivity : this.flowActivities) {
            for (PvmTransition transition : pvmActivity.getOutgoingTransitions()) {
                if (!transitionId.equals(transition.getId())) continue;
                return (TransitionImpl)transition;
            }
        }
        for (ActivityImpl activityImpl : this.flowActivities) {
            TransitionImpl nestedTransition = activityImpl.findTransition(transitionId);
            if (nestedTransition == null) continue;
            return nestedTransition;
        }
        return null;
    }

    @Override
    public ActivityImpl findActivityAtLevelOfSubprocess(String activityId) {
        if (!this.isSubProcessScope()) {
            throw new ProcessEngineException("This is not a sub process scope.");
        }
        ActivityImpl activity = this.findActivity(activityId);
        if (activity == null || activity.getLevelOfSubprocessScope() != this) {
            return null;
        }
        return activity;
    }

    @Override
    public ActivityImpl getChildActivity(String activityId) {
        return this.namedFlowActivities.get(activityId);
    }

    @Override
    public ActivityImpl createActivity(String activityId) {
        ActivityImpl activity = new ActivityImpl(activityId, this.processDefinition);
        if (activityId != null) {
            if (this.processDefinition.findActivity(activityId) != null) {
                throw new PvmException("duplicate activity id '" + activityId + "'");
            }
            this.namedFlowActivities.put(activityId, activity);
        }
        activity.flowScope = this;
        this.flowActivities.add(activity);
        return activity;
    }

    public boolean isAncestorFlowScopeOf(ScopeImpl other) {
        for (ScopeImpl otherAncestor = other.getFlowScope(); otherAncestor != null; otherAncestor = otherAncestor.getFlowScope()) {
            if (this != otherAncestor) continue;
            return true;
        }
        return false;
    }

    public boolean contains(ActivityImpl activity) {
        if (this.namedFlowActivities.containsKey(activity.getId())) {
            return true;
        }
        for (ActivityImpl nestedActivity : this.flowActivities) {
            if (!nestedActivity.contains(activity)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public List<ExecutionListener> getExecutionListeners(String eventName) {
        return super.getListeners(eventName);
    }

    @Deprecated
    public void addExecutionListener(String eventName, ExecutionListener executionListener) {
        super.addListener(eventName, executionListener);
    }

    @Deprecated
    public void addExecutionListener(String eventName, ExecutionListener executionListener, int index) {
        super.addListener(eventName, executionListener, index);
    }

    @Deprecated
    public Map<String, List<ExecutionListener>> getExecutionListeners() {
        return super.getListeners();
    }

    public List<ActivityImpl> getActivities() {
        return this.flowActivities;
    }

    @Override
    public boolean isSubProcessScope() {
        return this.isSubProcessScope;
    }

    public void setSubProcessScope(boolean isSubProcessScope) {
        this.isSubProcessScope = isSubProcessScope;
    }

    @Override
    public ProcessDefinitionImpl getProcessDefinition() {
        return this.processDefinition;
    }
}

