/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.osgi.el;

import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.beanutils.PropertyUtils;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.impl.javax.el.BeanELResolver;
import org.camunda.bpm.engine.impl.javax.el.ELContext;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class OSGiELResolver
extends BeanELResolver {
    private static final String LDAP_FILTER_KEY = "processExpression";

    /*
     * Unable to fully structure code
     */
    public Object getValue(ELContext context, Object base, Object property) {
        returnValue = null;
        if (base == null) {
            key = (String)property;
            try {
                ldapFilter = "(processExpression=" + key + ")";
                returnValue = this.checkRegisteredServicesByLdapFilter(ldapFilter);
                if (returnValue == null) {
                    returnValue = this.checkRegisteredOsgiServices(JavaDelegate.class.getName(), key);
                }
                if (returnValue != null) ** GOTO lbl21
                returnValue = this.checkRegisteredOsgiServices(ActivityBehavior.class.getName(), key);
            }
            catch (InvalidSyntaxException e) {
                throw new RuntimeException(e);
            }
        } else {
            try {
                readable = PropertyUtils.isReadable((Object)base, (String)property.toString());
                if (readable) {
                    returnValue = PropertyUtils.getProperty((Object)base, (String)property.toString());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
lbl21:
        // 3 sources

        if (returnValue != null) {
            context.setPropertyResolved(true);
        }
        return returnValue;
    }

    private Object checkRegisteredServicesByLdapFilter(String filter) throws InvalidSyntaxException {
        ServiceReference[] references = this.getBundleContext().getServiceReferences(null, filter);
        if (this.isEmptyOrNull(references)) {
            return null;
        }
        if (references.length == 1) {
            return this.getBundleContext().getService(references[0]);
        }
        throw new RuntimeException("Too many services registered for filter: " + filter);
    }

    private Object checkRegisteredOsgiServices(String serviceClazz, String key) throws InvalidSyntaxException {
        ServiceReference[] references = this.getBundleContext().getServiceReferences(serviceClazz, null);
        if (this.isEmptyOrNull(references)) {
            return null;
        }
        Collection<Object> matches = this.checkIfClassNamesMatchKey(references, key);
        if (matches.size() == 1) {
            return matches.iterator().next();
        }
        if (matches.size() > 1) {
            throw new RuntimeException("Too many " + serviceClazz + " registered with name: " + key);
        }
        return null;
    }

    private Collection<Object> checkIfClassNamesMatchKey(ServiceReference[] references, String key) {
        HashSet<Object> result = new HashSet<Object>();
        for (ServiceReference ref : references) {
            Object service = this.getBundleContext().getService(ref);
            if (service == null) continue;
            String keyWithFirstLetterUppercase = Character.toUpperCase(key.charAt(0)) + key.substring(1);
            if (!service.getClass().getSimpleName().equals(keyWithFirstLetterUppercase)) continue;
            result.add(service);
        }
        return result;
    }

    private boolean isEmptyOrNull(ServiceReference[] serviceReferences) {
        return serviceReferences == null ? true : serviceReferences.length == 0;
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        return true;
    }

    protected BundleContext getBundleContext() {
        return FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
    }
}

