/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.osgi.scripting.impl;

import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.scripting.engine.ScriptBindingsFactory;
import org.camunda.bpm.engine.impl.scripting.engine.ScriptingEngines;
import org.camunda.bpm.extension.osgi.scripting.ScriptEngineResolver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class OsgiScriptingEngines
extends ScriptingEngines {
    private static final Logger LOGGER = Logger.getLogger(OsgiScriptingEngines.class.getName());
    private BundleContext context;

    public OsgiScriptingEngines(ScriptBindingsFactory scriptBindingsFactory) {
        super(scriptBindingsFactory);
    }

    public Object evaluate(String script, String language, VariableScope variableScope) {
        ScriptEngine scriptEngine = null;
        try {
            scriptEngine = this.resolveScriptEngine(language);
        }
        catch (InvalidSyntaxException e) {
            throw new ProcessEngineException("problem resolving scripting engine" + e.getMessage(), (Throwable)e);
        }
        if (scriptEngine == null) {
            throw new ProcessEngineException("Can't find scripting engine for '" + language + "'");
        }
        Bindings bindings = this.createBindings(scriptEngine, variableScope);
        try {
            return scriptEngine.eval(script, bindings);
        }
        catch (ScriptException e) {
            throw new ProcessEngineException("problem evaluating script: " + e.getMessage(), (Throwable)e);
        }
    }

    protected BundleContext getBundleContext() {
        if (this.context == null) {
            this.context = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        }
        return this.context;
    }

    ScriptEngine resolveScriptEngine(String scriptEngineName) throws InvalidSyntaxException {
        ServiceReference[] refs = this.getBundleContext().getServiceReferences(ScriptEngineResolver.class.getName(), null);
        if (refs == null) {
            LOGGER.info("No OSGi script engine resolvers available!");
            return null;
        }
        LOGGER.fine("Found " + refs.length + " OSGi ScriptEngineResolver services");
        for (ServiceReference ref : refs) {
            ScriptEngineResolver resolver = (ScriptEngineResolver)this.getBundleContext().getService(ref);
            ScriptEngine engine = resolver.resolveScriptEngine(scriptEngineName);
            this.getBundleContext().ungetService(ref);
            LOGGER.fine("OSGi resolver " + resolver + " produced " + scriptEngineName + " engine " + engine);
            if (engine == null) continue;
            return engine;
        }
        return null;
    }
}

