/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.variable.impl.value.builder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.camunda.bpm.engine.variable.impl.value.FileValueImpl;
import org.camunda.bpm.engine.variable.type.PrimitiveValueType;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.camunda.bpm.engine.variable.value.builder.FileValueBuilder;
import org.camunda.commons.utils.EnsureUtil;
import org.camunda.commons.utils.IoUtil;

public class FileValueBuilderImpl
implements FileValueBuilder {
    protected FileValueImpl fileValue;

    public FileValueBuilderImpl(String filename) {
        EnsureUtil.ensureNotNull((String)"filename", (Object)filename);
        this.fileValue = new FileValueImpl(PrimitiveValueType.FILE, filename);
    }

    @Override
    public FileValue create() {
        return this.fileValue;
    }

    @Override
    public FileValueBuilder mimeType(String mimeType) {
        this.fileValue.setMimeType(mimeType);
        return this;
    }

    @Override
    public FileValueBuilder file(File file) {
        try {
            this.file(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    @Override
    public FileValueBuilder file(InputStream stream) {
        this.file(IoUtil.inputStreamAsString((InputStream)stream).getBytes());
        return this;
    }

    @Override
    public FileValueBuilder file(byte[] bytes) {
        this.fileValue.setValue(bytes);
        return this;
    }

    @Override
    public FileValueBuilder encoding(Charset encoding) {
        this.fileValue.setEncoding(encoding);
        return this;
    }

    @Override
    public FileValueBuilder encoding(String encoding) {
        this.fileValue.setEncoding(encoding);
        return this;
    }
}

