/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.feel.impl.juel.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.dmn.feel.impl.juel.transform.FeelToJuelTransform;
import org.camunda.bpm.dmn.feel.impl.juel.transform.FeelToJuelTransformer;

public class ListTransformer
implements FeelToJuelTransformer {
    @Override
    public boolean canTransform(String feelExpression) {
        return feelExpression.split(",").length > 1;
    }

    @Override
    public String transform(FeelToJuelTransform transform, String feelExpression, String inputName) {
        List<String> expressions = this.collectExpressions(feelExpression);
        List<String> juelExpressions = this.transformExpressions(transform, expressions, inputName);
        return this.joinExpressions(juelExpressions);
    }

    protected List<String> collectExpressions(String feelExpression) {
        return Arrays.asList(feelExpression.split(","));
    }

    protected List<String> transformExpressions(FeelToJuelTransform transform, List<String> expressions, String inputName) {
        ArrayList<String> juelExpressions = new ArrayList<String>();
        for (String expression : expressions) {
            String juelExpression = transform.transformSimplePositiveUnaryTest(expression, inputName);
            juelExpressions.add(juelExpression);
        }
        return juelExpressions;
    }

    protected String joinExpressions(List<String> juelExpressions) {
        StringBuilder builder = new StringBuilder();
        builder.append("(").append(juelExpressions.get(0)).append(")");
        for (int i = 1; i < juelExpressions.size(); ++i) {
            builder.append(" || (").append(juelExpressions.get(i)).append(")");
        }
        return builder.toString();
    }
}

