/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.instance.command;

import org.apache.karaf.instance.command.InstanceCommandSupport;
import org.apache.karaf.instance.core.Instance;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;

@Command(scope="instance", name="start", description="Start an existing container instance.")
public class StartCommand
extends InstanceCommandSupport {
    @Option(name="-d", aliases={"--debug"}, description="Start the instance in debug mode", required=false, multiValued=false)
    private boolean debug;
    @Option(name="-o", aliases={"--java-opts"}, description="Java options when launching the instance", required=false, multiValued=false)
    private String javaOpts;
    @Option(name="-w", aliases={"--wait"}, description="Wait for the instance to be fully started", required=false, multiValued=false)
    private boolean wait;
    @Argument(index=0, name="name", description="The name of the container instance", required=true, multiValued=false)
    private String instance = null;
    static final String DEBUG_OPTS = " -Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=5005";
    static final String DEFAULT_OPTS = "-server -Xmx512M -Dcom.sun.management.jmxremote";

    protected Object doExecute() throws Exception {
        Instance child = this.getExistingInstance(this.instance);
        String opts = this.javaOpts;
        if (opts == null) {
            opts = child.getJavaOpts();
        }
        if (opts == null) {
            opts = DEFAULT_OPTS;
        }
        if (this.debug) {
            opts = opts + DEBUG_OPTS;
        }
        if (this.wait) {
            String state = child.getState();
            if ("Stopped".equals(state)) {
                child.start(opts);
            }
            if (!"Started".equals(state)) {
                do {
                    Thread.sleep(500L);
                } while ("Starting".equals(state = child.getState()));
            }
        } else {
            child.start(opts);
        }
        return null;
    }
}

