/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl.hitpolicy;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.AnyHitPolicyHandler;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.CollectCountHitPolicyHandler;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.CollectHitPolicyHandler;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.CollectMaxHitPolicyHandler;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.CollectMinHitPolicyHandler;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.CollectSumHitPolicyHandler;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.FirstHitPolicyHandler;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.RuleOrderHitPolicyHandler;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.UniqueHitPolicyHandler;
import org.camunda.bpm.dmn.engine.impl.spi.hitpolicy.DmnHitPolicyHandler;
import org.camunda.bpm.dmn.engine.impl.spi.hitpolicy.DmnHitPolicyHandlerRegistry;
import org.camunda.bpm.model.dmn.BuiltinAggregator;
import org.camunda.bpm.model.dmn.HitPolicy;

public class DefaultHitPolicyHandlerRegistry
implements DmnHitPolicyHandlerRegistry {
    protected static final Map<HitPolicyEntry, DmnHitPolicyHandler> handlers = DefaultHitPolicyHandlerRegistry.getDefaultHandlers();

    protected static Map<HitPolicyEntry, DmnHitPolicyHandler> getDefaultHandlers() {
        HashMap<HitPolicyEntry, DmnHitPolicyHandler> handlers = new HashMap<HitPolicyEntry, DmnHitPolicyHandler>();
        handlers.put(new HitPolicyEntry(HitPolicy.UNIQUE, null), new UniqueHitPolicyHandler());
        handlers.put(new HitPolicyEntry(HitPolicy.FIRST, null), new FirstHitPolicyHandler());
        handlers.put(new HitPolicyEntry(HitPolicy.ANY, null), new AnyHitPolicyHandler());
        handlers.put(new HitPolicyEntry(HitPolicy.RULE_ORDER, null), new RuleOrderHitPolicyHandler());
        handlers.put(new HitPolicyEntry(HitPolicy.COLLECT, null), new CollectHitPolicyHandler());
        handlers.put(new HitPolicyEntry(HitPolicy.COLLECT, BuiltinAggregator.COUNT), new CollectCountHitPolicyHandler());
        handlers.put(new HitPolicyEntry(HitPolicy.COLLECT, BuiltinAggregator.SUM), new CollectSumHitPolicyHandler());
        handlers.put(new HitPolicyEntry(HitPolicy.COLLECT, BuiltinAggregator.MIN), new CollectMinHitPolicyHandler());
        handlers.put(new HitPolicyEntry(HitPolicy.COLLECT, BuiltinAggregator.MAX), new CollectMaxHitPolicyHandler());
        return handlers;
    }

    @Override
    public DmnHitPolicyHandler getHandler(HitPolicy hitPolicy, BuiltinAggregator builtinAggregator) {
        return handlers.get(new HitPolicyEntry(hitPolicy, builtinAggregator));
    }

    @Override
    public void addHandler(HitPolicy hitPolicy, BuiltinAggregator builtinAggregator, DmnHitPolicyHandler hitPolicyHandler) {
        handlers.put(new HitPolicyEntry(hitPolicy, builtinAggregator), hitPolicyHandler);
    }

    public static class HitPolicyEntry {
        protected final HitPolicy hitPolicy;
        protected final BuiltinAggregator builtinAggregator;

        public HitPolicyEntry(HitPolicy hitPolicy, BuiltinAggregator builtinAggregator) {
            this.hitPolicy = hitPolicy;
            this.builtinAggregator = builtinAggregator;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HitPolicyEntry that = (HitPolicyEntry)o;
            if (this.hitPolicy != that.hitPolicy) {
                return false;
            }
            return this.builtinAggregator == that.builtinAggregator;
        }

        public int hashCode() {
            int result = this.hitPolicy != null ? this.hitPolicy.hashCode() : 0;
            result = 31 * result + (this.builtinAggregator != null ? this.builtinAggregator.hashCode() : 0);
            return result;
        }
    }
}

