/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl.transform;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.dmn.engine.DmnDecision;
import org.camunda.bpm.dmn.engine.impl.DmnDecisionTableImpl;
import org.camunda.bpm.dmn.engine.impl.DmnDecisionTableInputImpl;
import org.camunda.bpm.dmn.engine.impl.DmnDecisionTableOutputImpl;
import org.camunda.bpm.dmn.engine.impl.DmnDecisionTableRuleImpl;
import org.camunda.bpm.dmn.engine.impl.DmnExpressionImpl;
import org.camunda.bpm.dmn.engine.impl.DmnLogger;
import org.camunda.bpm.dmn.engine.impl.spi.hitpolicy.DmnHitPolicyHandlerRegistry;
import org.camunda.bpm.dmn.engine.impl.spi.transform.DmnElementTransformContext;
import org.camunda.bpm.dmn.engine.impl.spi.transform.DmnElementTransformHandler;
import org.camunda.bpm.dmn.engine.impl.spi.transform.DmnElementTransformHandlerRegistry;
import org.camunda.bpm.dmn.engine.impl.spi.transform.DmnTransform;
import org.camunda.bpm.dmn.engine.impl.spi.transform.DmnTransformListener;
import org.camunda.bpm.dmn.engine.impl.spi.transform.DmnTransformer;
import org.camunda.bpm.dmn.engine.impl.spi.type.DmnDataTypeTransformerRegistry;
import org.camunda.bpm.dmn.engine.impl.transform.DmnTransformLogger;
import org.camunda.bpm.model.dmn.Dmn;
import org.camunda.bpm.model.dmn.DmnModelException;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.camunda.bpm.model.dmn.instance.Decision;
import org.camunda.bpm.model.dmn.instance.DecisionTable;
import org.camunda.bpm.model.dmn.instance.Definitions;
import org.camunda.bpm.model.dmn.instance.Expression;
import org.camunda.bpm.model.dmn.instance.Input;
import org.camunda.bpm.model.dmn.instance.InputEntry;
import org.camunda.bpm.model.dmn.instance.InputExpression;
import org.camunda.bpm.model.dmn.instance.Output;
import org.camunda.bpm.model.dmn.instance.OutputEntry;
import org.camunda.bpm.model.dmn.instance.Rule;
import org.camunda.commons.utils.EnsureUtil;

public class DefaultDmnTransform
implements DmnTransform,
DmnElementTransformContext {
    private static final DmnTransformLogger LOG = DmnLogger.TRANSFORM_LOGGER;
    protected DmnTransformer transformer;
    protected List<DmnTransformListener> transformListeners;
    protected DmnElementTransformHandlerRegistry handlerRegistry;
    protected DmnModelInstance modelInstance;
    protected Object parent;
    protected DmnDecision decision;
    protected DmnDataTypeTransformerRegistry dataTypeTransformerRegistry;
    protected DmnHitPolicyHandlerRegistry hitPolicyHandlerRegistry;

    public DefaultDmnTransform(DmnTransformer transformer) {
        this.transformer = transformer;
        this.transformListeners = transformer.getTransformListeners();
        this.handlerRegistry = transformer.getElementTransformHandlerRegistry();
        this.dataTypeTransformerRegistry = transformer.getDataTypeTransformerRegistry();
        this.hitPolicyHandlerRegistry = transformer.getHitPolicyHandlerRegistry();
    }

    @Override
    public void setModelInstance(File file) {
        EnsureUtil.ensureNotNull((String)"file", (Object)file);
        try {
            this.modelInstance = Dmn.readModelFromFile((File)file);
        }
        catch (DmnModelException e) {
            throw LOG.unableToTransformDecisionsFromFile(file, e);
        }
    }

    @Override
    public DmnTransform modelInstance(File file) {
        this.setModelInstance(file);
        return this;
    }

    @Override
    public void setModelInstance(InputStream inputStream) {
        EnsureUtil.ensureNotNull((String)"inputStream", (Object)inputStream);
        try {
            this.modelInstance = Dmn.readModelFromStream((InputStream)inputStream);
        }
        catch (DmnModelException e) {
            throw LOG.unableToTransformDecisionsFromInputStream(e);
        }
    }

    @Override
    public DmnTransform modelInstance(InputStream inputStream) {
        this.setModelInstance(inputStream);
        return this;
    }

    @Override
    public void setModelInstance(DmnModelInstance modelInstance) {
        EnsureUtil.ensureNotNull((String)"dmnModelInstance", (Object)modelInstance);
        this.modelInstance = modelInstance;
    }

    @Override
    public DmnTransform modelInstance(DmnModelInstance modelInstance) {
        this.setModelInstance(modelInstance);
        return this;
    }

    @Override
    public <T extends DmnDecision> List<T> transformDecisions() {
        try {
            Definitions definitions = this.modelInstance.getDefinitions();
            Collection decisions = definitions.getChildElementsByType(Decision.class);
            ArrayList<DmnDecision> dmnDecisions = new ArrayList<DmnDecision>();
            for (Decision decision : decisions) {
                DmnDecision dmnDecision = this.transformDecision(decision);
                if (dmnDecision == null) continue;
                dmnDecisions.add(dmnDecision);
                this.notifyTransformListeners(decision, dmnDecision);
            }
            return dmnDecisions;
        }
        catch (Exception e) {
            throw LOG.errorWhileTransforming(e);
        }
    }

    protected DmnDecision transformDecision(Decision decision) {
        Expression expression = decision.getExpression();
        if (expression == null) {
            LOG.decisionWithoutExpression(decision);
            return null;
        }
        if (expression instanceof DecisionTable) {
            return this.transformDecisionTable((DecisionTable)expression);
        }
        LOG.decisionTypeNotSupported(expression, decision);
        return null;
    }

    protected DmnDecision transformDecisionTable(DecisionTable decisionTable) {
        DmnElementTransformHandler handler = this.handlerRegistry.getHandler(DecisionTable.class);
        DmnDecisionTableImpl dmnDecisionTable = (DmnDecisionTableImpl)handler.handleElement(this, decisionTable);
        if (dmnDecisionTable.getKey() == null) {
            throw LOG.decisionIdIsMissing(dmnDecisionTable);
        }
        for (Input input : decisionTable.getInputs()) {
            this.parent = dmnDecisionTable;
            this.decision = dmnDecisionTable;
            DmnDecisionTableInputImpl dmnInput = this.transformDecisionTableInput(input);
            if (dmnInput == null) continue;
            dmnDecisionTable.getInputs().add(dmnInput);
            this.notifyTransformListeners(input, dmnInput);
        }
        boolean needsName = decisionTable.getOutputs().size() > 1;
        HashSet<String> usedNames = new HashSet<String>();
        for (Output output : decisionTable.getOutputs()) {
            this.parent = dmnDecisionTable;
            this.decision = dmnDecisionTable;
            DmnDecisionTableOutputImpl dmnOutput = this.transformDecisionTableOutput(output);
            if (dmnOutput == null) continue;
            String outputName = dmnOutput.getOutputName();
            if (needsName && outputName == null) {
                throw LOG.compoundOutputsShouldHaveAnOutputName(dmnDecisionTable, dmnOutput);
            }
            if (usedNames.contains(outputName)) {
                throw LOG.compoundOutputWithDuplicateName(dmnDecisionTable, dmnOutput);
            }
            usedNames.add(outputName);
            dmnDecisionTable.getOutputs().add(dmnOutput);
            this.notifyTransformListeners(output, dmnOutput);
        }
        for (Rule rule : decisionTable.getRules()) {
            this.parent = dmnDecisionTable;
            this.decision = dmnDecisionTable;
            DmnDecisionTableRuleImpl dmnRule = this.transformDecisionTableRule(rule);
            if (dmnRule == null) continue;
            dmnDecisionTable.getRules().add(dmnRule);
            this.notifyTransformListeners(rule, dmnRule);
        }
        return dmnDecisionTable;
    }

    protected DmnDecisionTableInputImpl transformDecisionTableInput(Input input) {
        DmnElementTransformHandler handler = this.handlerRegistry.getHandler(Input.class);
        DmnDecisionTableInputImpl dmnInput = (DmnDecisionTableInputImpl)handler.handleElement(this, input);
        if (dmnInput.getId() == null) {
            throw LOG.decisionTableInputIdIsMissing(this.decision, dmnInput);
        }
        InputExpression inputExpression = input.getInputExpression();
        if (inputExpression != null) {
            this.parent = dmnInput;
            DmnExpressionImpl dmnExpression = this.transformInputExpression(inputExpression);
            if (dmnExpression != null) {
                dmnInput.setExpression(dmnExpression);
            }
        }
        return dmnInput;
    }

    protected DmnDecisionTableOutputImpl transformDecisionTableOutput(Output output) {
        DmnElementTransformHandler handler = this.handlerRegistry.getHandler(Output.class);
        DmnDecisionTableOutputImpl dmnOutput = (DmnDecisionTableOutputImpl)handler.handleElement(this, output);
        if (dmnOutput.getId() == null) {
            throw LOG.decisionTableOutputIdIsMissing(this.decision, dmnOutput);
        }
        return dmnOutput;
    }

    protected DmnDecisionTableRuleImpl transformDecisionTableRule(Rule rule) {
        DmnElementTransformHandler handler = this.handlerRegistry.getHandler(Rule.class);
        DmnDecisionTableRuleImpl dmnRule = (DmnDecisionTableRuleImpl)handler.handleElement(this, rule);
        if (dmnRule.getId() == null) {
            throw LOG.decisionTableRuleIdIsMissing(this.decision, dmnRule);
        }
        DmnDecisionTableImpl dmnDecisionTable = (DmnDecisionTableImpl)this.decision;
        List<DmnDecisionTableInputImpl> inputs = dmnDecisionTable.getInputs();
        ArrayList inputEntries = new ArrayList(rule.getInputEntries());
        if (inputs.size() != inputEntries.size()) {
            throw LOG.differentNumberOfInputsAndInputEntries(inputs.size(), inputEntries.size(), dmnRule);
        }
        for (InputEntry inputEntry : inputEntries) {
            this.parent = dmnRule;
            DmnExpressionImpl condition = this.transformInputEntry(inputEntry);
            dmnRule.getConditions().add(condition);
        }
        List<DmnDecisionTableOutputImpl> outputs = dmnDecisionTable.getOutputs();
        ArrayList outputEntries = new ArrayList(rule.getOutputEntries());
        if (outputs.size() != outputEntries.size()) {
            throw LOG.differentNumberOfOutputsAndOutputEntries(outputs.size(), outputEntries.size(), dmnRule);
        }
        for (OutputEntry outputEntry : outputEntries) {
            this.parent = dmnRule;
            DmnExpressionImpl conclusion = this.transformOutputEntry(outputEntry);
            dmnRule.getConclusions().add(conclusion);
        }
        return dmnRule;
    }

    protected DmnExpressionImpl transformInputExpression(InputExpression inputExpression) {
        DmnElementTransformHandler handler = this.handlerRegistry.getHandler(InputExpression.class);
        return (DmnExpressionImpl)handler.handleElement(this, inputExpression);
    }

    protected DmnExpressionImpl transformInputEntry(InputEntry inputEntry) {
        DmnElementTransformHandler handler = this.handlerRegistry.getHandler(InputEntry.class);
        return (DmnExpressionImpl)handler.handleElement(this, inputEntry);
    }

    protected DmnExpressionImpl transformOutputEntry(OutputEntry outputEntry) {
        DmnElementTransformHandler handler = this.handlerRegistry.getHandler(OutputEntry.class);
        return (DmnExpressionImpl)handler.handleElement(this, outputEntry);
    }

    protected void notifyTransformListeners(Decision decision, DmnDecision dmnDecision) {
        for (DmnTransformListener transformListener : this.transformListeners) {
            transformListener.transformDecision(decision, dmnDecision);
        }
    }

    protected void notifyTransformListeners(Input input, DmnDecisionTableInputImpl dmnInput) {
        for (DmnTransformListener transformListener : this.transformListeners) {
            transformListener.transformDecisionTableInput(input, dmnInput);
        }
    }

    protected void notifyTransformListeners(Output output, DmnDecisionTableOutputImpl dmnOutput) {
        for (DmnTransformListener transformListener : this.transformListeners) {
            transformListener.transformDecisionTableOutput(output, dmnOutput);
        }
    }

    protected void notifyTransformListeners(Rule rule, DmnDecisionTableRuleImpl dmnRule) {
        for (DmnTransformListener transformListener : this.transformListeners) {
            transformListener.transformDecisionTableRule(rule, dmnRule);
        }
    }

    @Override
    public DmnModelInstance getModelInstance() {
        return this.modelInstance;
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    @Override
    public DmnDecision getDecision() {
        return this.decision;
    }

    @Override
    public DmnDataTypeTransformerRegistry getDataTypeTransformerRegistry() {
        return this.dataTypeTransformerRegistry;
    }

    @Override
    public DmnHitPolicyHandlerRegistry getHitPolicyHandlerRegistry() {
        return this.hitPolicyHandlerRegistry;
    }
}

