/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.specs.activation;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import org.apache.geronimo.specs.activation.Activator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class CommandMapBundleTrackerCustomizer
implements BundleTrackerCustomizer {
    private Activator activator;
    private Bundle activationBundle;
    private ConcurrentMap<Long, URL> mailCaps = new ConcurrentHashMap<Long, URL>();

    public CommandMapBundleTrackerCustomizer(Activator a, Bundle b) {
        this.activator = a;
        this.activationBundle = b;
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        if (bundle.equals(this.activationBundle)) {
            return null;
        }
        return this.registerBundle(bundle);
    }

    private Object registerBundle(Bundle bundle) {
        URL url = bundle.getResource("/META-INF/mailcap");
        if (url != null) {
            this.log(4, "found mailcap at " + url);
            this.mailCaps.put(bundle.getBundleId(), url);
            this.rebuildCommandMap();
        }
        return url;
    }

    protected void unregisterBundle(Bundle bundle) {
        URL mailcap = (URL)this.mailCaps.remove(bundle.getBundleId());
        if (mailcap != null) {
            this.log(4, "removing mailcap at " + mailcap);
            this.rebuildCommandMap();
        }
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        this.log(4, "Bundle Considered for mailcap providers: " + bundle.getSymbolicName());
        this.registerBundle(bundle);
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        this.unregisterBundle(bundle);
    }

    private void log(int level, String message) {
        this.activator.log(level, message);
    }

    private void log(int level, String message, Throwable th) {
        this.activator.log(level, message, th);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildCommandMap() {
        MailcapCommandMap commandMap = new MailcapCommandMap();
        for (URL url : this.mailCaps.values()) {
            try {
                InputStream is = url.openStream();
                try {
                    String line;
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    while ((line = br.readLine()) != null) {
                        commandMap.addMailcap(line);
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (Exception e) {}
        }
        CommandMap.setDefaultCommandMap(commandMap);
    }
}

