/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.blueprint.codec;

import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.apache.aries.jmx.blueprint.BlueprintMetadataMBean;
import org.apache.aries.jmx.blueprint.codec.BPBeanArgument;
import org.apache.aries.jmx.blueprint.codec.BPBeanProperty;
import org.apache.aries.jmx.blueprint.codec.BPComponentMetadata;
import org.apache.aries.jmx.blueprint.codec.BPTarget;
import org.apache.aries.jmx.blueprint.codec.Util;
import org.osgi.service.blueprint.reflect.BeanArgument;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.BeanProperty;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPBeanMetadata
extends BPComponentMetadata
implements BPTarget {
    private String className;
    private String destroyMethod;
    private String factoryMethod;
    private String initMethod;
    private String scope;
    private BPBeanArgument[] arguments;
    private BPBeanProperty[] properties;
    private BPTarget factoryComponent;

    public BPBeanMetadata(CompositeData bean) {
        super(bean);
        this.className = (String)bean.get("ClassName");
        this.destroyMethod = (String)bean.get("DestroyMethod");
        this.factoryMethod = (String)bean.get("FactoryMethod");
        this.initMethod = (String)bean.get("InitMethod");
        this.scope = (String)bean.get("Scope");
        Byte[] buf = (Byte[])bean.get("FactoryComponent");
        this.factoryComponent = (BPTarget)Util.boxedBinary2BPMetadata(buf);
        CompositeData[] cd_args = (CompositeData[])bean.get("Arguments");
        this.arguments = new BPBeanArgument[cd_args.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            this.arguments[i] = new BPBeanArgument(cd_args[i]);
        }
        CompositeData[] cd_props = (CompositeData[])bean.get("Properties");
        this.properties = new BPBeanProperty[cd_props.length];
        for (int i = 0; i < this.properties.length; ++i) {
            this.properties[i] = new BPBeanProperty(cd_props[i]);
        }
    }

    public BPBeanMetadata(BeanMetadata bean) {
        super((ComponentMetadata)bean);
        this.className = bean.getClassName();
        this.destroyMethod = bean.getDestroyMethod();
        this.factoryMethod = bean.getFactoryMethod();
        this.initMethod = bean.getInitMethod();
        this.scope = bean.getScope();
        this.factoryComponent = (BPTarget)Util.metadata2BPMetadata((Metadata)bean.getFactoryComponent());
        this.arguments = new BPBeanArgument[bean.getArguments().size()];
        int i = 0;
        for (Object arg : bean.getArguments()) {
            this.arguments[i++] = new BPBeanArgument((BeanArgument)arg);
        }
        this.properties = new BPBeanProperty[bean.getProperties().size()];
        i = 0;
        for (Object prop : bean.getProperties()) {
            this.properties[i++] = new BPBeanProperty((BeanProperty)prop);
        }
    }

    @Override
    protected Map<String, Object> getItemsMap() {
        Map<String, Object> items = super.getItemsMap();
        items.put("ClassName", this.className);
        items.put("DestroyMethod", this.destroyMethod);
        items.put("FactoryMethod", this.factoryMethod);
        items.put("InitMethod", this.initMethod);
        items.put("Scope", this.scope);
        items.put("FactoryComponent", Util.bpMetadata2BoxedBinary(this.factoryComponent));
        CompositeData[] cd_args = new CompositeData[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            cd_args[i] = this.arguments[i].asCompositeData();
        }
        items.put("Arguments", cd_args);
        CompositeData[] cd_props = new CompositeData[this.properties.length];
        for (int i = 0; i < this.properties.length; ++i) {
            cd_props[i] = this.properties[i].asCompositeData();
        }
        items.put("Properties", cd_props);
        return items;
    }

    @Override
    public CompositeData asCompositeData() {
        try {
            return new CompositeDataSupport(BlueprintMetadataMBean.BEAN_METADATA_TYPE, this.getItemsMap());
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    public BPBeanArgument[] getArguments() {
        return this.arguments;
    }

    public String getClassName() {
        return this.className;
    }

    public String getDestroyMethod() {
        return this.destroyMethod;
    }

    public BPTarget getFactoryComponent() {
        return this.factoryComponent;
    }

    public String getFactoryMethod() {
        return this.factoryMethod;
    }

    public String getInitMethod() {
        return this.initMethod;
    }

    public BPBeanProperty[] getProperties() {
        return this.properties;
    }

    public String getScope() {
        return this.scope;
    }
}

