/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.diagnostic.core.internal;

import java.io.File;
import java.util.List;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.karaf.diagnostic.core.DiagnosticDumpMBean;
import org.apache.karaf.diagnostic.core.DumpDestination;
import org.apache.karaf.diagnostic.core.DumpProvider;
import org.apache.karaf.diagnostic.core.common.DirectoryDumpDestination;
import org.apache.karaf.diagnostic.core.common.ZipDumpDestination;

public class DiagnosticDumpMBeanImpl
extends StandardMBean
implements DiagnosticDumpMBean {
    private List<DumpProvider> providers;

    public DiagnosticDumpMBeanImpl() throws NotCompliantMBeanException {
        super(DiagnosticDumpMBean.class);
    }

    @Override
    public void createDump(String name) throws MBeanException {
        this.createDump(false, name);
    }

    @Override
    public void createDump(boolean directory, String name) throws MBeanException {
        try {
            File target = new File(name);
            DumpDestination destination = directory ? new DirectoryDumpDestination(target) : new ZipDumpDestination(target);
            for (DumpProvider provider : this.providers) {
                provider.createDump(destination);
            }
            destination.save();
        }
        catch (Exception e) {
            throw new MBeanException(null, e.getMessage());
        }
    }

    public void setProviders(List<DumpProvider> providers) {
        this.providers = providers;
    }
}

