/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.instance.parser;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingProcessElementInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingProcessInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingTransitionInstance;
import org.camunda.bpm.engine.impl.migration.instance.parser.ActivityInstanceHandler;
import org.camunda.bpm.engine.impl.migration.instance.parser.ActivityInstanceJobHandler;
import org.camunda.bpm.engine.impl.migration.instance.parser.ActivityInstanceWalker;
import org.camunda.bpm.engine.impl.migration.instance.parser.CompensationEventSubscriptionWalker;
import org.camunda.bpm.engine.impl.migration.instance.parser.CompensationInstanceHandler;
import org.camunda.bpm.engine.impl.migration.instance.parser.EventSubscriptionInstanceHandler;
import org.camunda.bpm.engine.impl.migration.instance.parser.IncidentInstanceHandler;
import org.camunda.bpm.engine.impl.migration.instance.parser.MigratingDependentInstanceParseHandler;
import org.camunda.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseContext;
import org.camunda.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseHandler;
import org.camunda.bpm.engine.impl.migration.instance.parser.TransitionInstanceHandler;
import org.camunda.bpm.engine.impl.migration.instance.parser.TransitionInstanceJobHandler;
import org.camunda.bpm.engine.impl.migration.instance.parser.VariableInstanceHandler;
import org.camunda.bpm.engine.impl.migration.validation.instance.MigratingProcessInstanceValidationReportImpl;
import org.camunda.bpm.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.tree.TreeVisitor;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.TransitionInstance;

public class MigratingInstanceParser {
    protected ProcessEngine engine;
    protected MigratingInstanceParseHandler<ActivityInstance> activityInstanceHandler = new ActivityInstanceHandler();
    protected MigratingInstanceParseHandler<TransitionInstance> transitionInstanceHandler = new TransitionInstanceHandler();
    protected MigratingInstanceParseHandler<CompensateEventSubscriptionEntity> compensationInstanceHandler = new CompensationInstanceHandler();
    protected MigratingDependentInstanceParseHandler<MigratingActivityInstance, List<JobEntity>> dependentActivityInstanceJobHandler = new ActivityInstanceJobHandler();
    protected MigratingDependentInstanceParseHandler<MigratingTransitionInstance, List<JobEntity>> dependentTransitionInstanceJobHandler = new TransitionInstanceJobHandler();
    protected MigratingDependentInstanceParseHandler<MigratingActivityInstance, List<EventSubscriptionEntity>> dependentEventSubscriptionHandler = new EventSubscriptionInstanceHandler();
    protected MigratingDependentInstanceParseHandler<MigratingProcessElementInstance, List<VariableInstanceEntity>> dependentVariableHandler = new VariableInstanceHandler();
    protected MigratingInstanceParseHandler<IncidentEntity> incidentHandler = new IncidentInstanceHandler();

    public MigratingInstanceParser(ProcessEngine engine) {
        this.engine = engine;
    }

    public MigratingProcessInstance parse(String processInstanceId, MigrationPlan migrationPlan, MigratingProcessInstanceValidationReportImpl processInstanceReport) {
        CommandContext commandContext = Context.getCommandContext();
        List<EventSubscriptionEntity> eventSubscriptions = this.fetchEventSubscriptions(commandContext, processInstanceId);
        List<ExecutionEntity> executions = this.fetchExecutions(commandContext, processInstanceId);
        List<ExternalTaskEntity> externalTasks = this.fetchExternalTasks(commandContext, processInstanceId);
        List<IncidentEntity> incidents = this.fetchIncidents(commandContext, processInstanceId);
        List<JobEntity> jobs = this.fetchJobs(commandContext, processInstanceId);
        List<TaskEntity> tasks = this.fetchTasks(commandContext, processInstanceId);
        List<VariableInstanceEntity> variables = this.fetchVariables(commandContext, processInstanceId);
        ExecutionEntity processInstance = commandContext.getExecutionManager().findExecutionById(processInstanceId);
        processInstance.restoreProcessInstance(executions, eventSubscriptions, variables, tasks, jobs, incidents, externalTasks);
        ProcessDefinitionEntity targetProcessDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(migrationPlan.getTargetProcessDefinitionId());
        List<JobDefinitionEntity> targetJobDefinitions = this.fetchJobDefinitions(commandContext, targetProcessDefinition.getId());
        final MigratingInstanceParseContext parseContext = new MigratingInstanceParseContext(this, migrationPlan, processInstance, targetProcessDefinition).eventSubscriptions(eventSubscriptions).externalTasks(externalTasks).incidents(incidents).jobs(jobs).tasks(tasks).targetJobDefinitions(targetJobDefinitions).variables(variables);
        ActivityInstance activityInstance = this.engine.getRuntimeService().getActivityInstance(processInstanceId);
        ActivityInstanceWalker activityInstanceWalker = new ActivityInstanceWalker(activityInstance);
        activityInstanceWalker.addPreVisitor(new TreeVisitor<ActivityInstance>(){

            @Override
            public void visit(ActivityInstance obj) {
                MigratingInstanceParser.this.activityInstanceHandler.handle(parseContext, obj);
            }
        });
        activityInstanceWalker.walkWhile();
        CompensationEventSubscriptionWalker compensateSubscriptionsWalker = new CompensationEventSubscriptionWalker(parseContext.getMigratingActivityInstances());
        compensateSubscriptionsWalker.addPreVisitor(new TreeVisitor<CompensateEventSubscriptionEntity>(){

            @Override
            public void visit(CompensateEventSubscriptionEntity obj) {
                MigratingInstanceParser.this.compensationInstanceHandler.handle(parseContext, obj);
            }
        });
        compensateSubscriptionsWalker.walkWhile();
        for (IncidentEntity incidentEntity : incidents) {
            this.incidentHandler.handle(parseContext, incidentEntity);
        }
        parseContext.validateNoEntitiesLeft(processInstanceReport);
        return parseContext.getMigratingProcessInstance();
    }

    public MigratingInstanceParseHandler<ActivityInstance> getActivityInstanceHandler() {
        return this.activityInstanceHandler;
    }

    public MigratingInstanceParseHandler<TransitionInstance> getTransitionInstanceHandler() {
        return this.transitionInstanceHandler;
    }

    public MigratingDependentInstanceParseHandler<MigratingActivityInstance, List<EventSubscriptionEntity>> getDependentEventSubscriptionHandler() {
        return this.dependentEventSubscriptionHandler;
    }

    public MigratingDependentInstanceParseHandler<MigratingActivityInstance, List<JobEntity>> getDependentActivityInstanceJobHandler() {
        return this.dependentActivityInstanceJobHandler;
    }

    public MigratingDependentInstanceParseHandler<MigratingTransitionInstance, List<JobEntity>> getDependentTransitionInstanceJobHandler() {
        return this.dependentTransitionInstanceJobHandler;
    }

    public MigratingInstanceParseHandler<IncidentEntity> getIncidentHandler() {
        return this.incidentHandler;
    }

    public MigratingDependentInstanceParseHandler<MigratingProcessElementInstance, List<VariableInstanceEntity>> getDependentVariablesHandler() {
        return this.dependentVariableHandler;
    }

    protected List<ExecutionEntity> fetchExecutions(CommandContext commandContext, String processInstanceId) {
        return commandContext.getExecutionManager().findExecutionsByProcessInstanceId(processInstanceId);
    }

    protected List<EventSubscriptionEntity> fetchEventSubscriptions(CommandContext commandContext, String processInstanceId) {
        return commandContext.getEventSubscriptionManager().findEventSubscriptionsByProcessInstanceId(processInstanceId);
    }

    protected List<ExternalTaskEntity> fetchExternalTasks(CommandContext commandContext, String processInstanceId) {
        return commandContext.getExternalTaskManager().findExternalTasksByProcessInstanceId(processInstanceId);
    }

    protected List<JobEntity> fetchJobs(CommandContext commandContext, String processInstanceId) {
        return commandContext.getJobManager().findJobsByProcessInstanceId(processInstanceId);
    }

    protected List<IncidentEntity> fetchIncidents(CommandContext commandContext, String processInstanceId) {
        return commandContext.getIncidentManager().findIncidentsByProcessInstance(processInstanceId);
    }

    protected List<TaskEntity> fetchTasks(CommandContext commandContext, String processInstanceId) {
        return commandContext.getTaskManager().findTasksByProcessInstanceId(processInstanceId);
    }

    protected List<JobDefinitionEntity> fetchJobDefinitions(CommandContext commandContext, String processDefinitionId) {
        return commandContext.getJobDefinitionManager().findByProcessDefinitionId(processDefinitionId);
    }

    protected List<VariableInstanceEntity> fetchVariables(CommandContext commandContext, String processInstanceId) {
        return commandContext.getVariableInstanceManager().findVariableInstancesByProcessInstanceId(processInstanceId);
    }
}

