/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import org.apache.karaf.bundle.core.BundleInfo;
import org.apache.karaf.bundle.core.BundleService;
import org.apache.karaf.bundle.core.BundleState;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.karaf.shell.table.ShellTable;
import org.osgi.framework.Bundle;
import org.osgi.framework.startlevel.FrameworkStartLevel;

@Command(scope="bundle", name="list", description="Lists all installed bundles.")
public class ListBundles
extends OsgiCommandSupport {
    @Option(name="-l", aliases={}, description="Show the locations", required=false, multiValued=false)
    boolean showLoc;
    @Option(name="-s", description="Shows the symbolic name", required=false, multiValued=false)
    boolean showSymbolic;
    @Option(name="-u", description="Shows the update locations", required=false, multiValued=false)
    boolean showUpdate;
    @Option(name="-r", description="Shows the bundle revisions", required=false, multiValued=false)
    boolean showRevisions;
    @Option(name="-t", valueToShowInHelp="", description="Specifies the bundle threshold; bundles with a start-level less than this value will not get printed out.", required=false, multiValued=false)
    int bundleLevelThreshold = -1;
    @Option(name="--no-format", description="Disable table rendered output", required=false, multiValued=false)
    boolean noFormat;
    private BundleService bundleService;

    public void setBundleService(BundleService bundleService) {
        this.bundleService = bundleService;
    }

    protected Object doExecute() throws Exception {
        Bundle[] bundles = this.getBundleContext().getBundles();
        if (bundles == null) {
            System.out.println("There are no installed bundles.");
            return null;
        }
        this.determineBundleLevelThreshold();
        FrameworkStartLevel fsl = (FrameworkStartLevel)this.getBundleContext().getBundle(0L).adapt(FrameworkStartLevel.class);
        if (fsl != null) {
            System.out.println("START LEVEL " + fsl.getStartLevel() + " , List Threshold: " + this.bundleLevelThreshold);
        }
        ShellTable table = new ShellTable();
        table.column("ID").alignRight();
        table.column("State");
        table.column("Lvl").alignRight();
        table.column("Version");
        table.column(this.getNameHeader());
        for (int i = 0; i < bundles.length; ++i) {
            Bundle bundle = bundles[i];
            BundleInfo info = this.bundleService.getInfo(bundle);
            if (info.getStartLevel() < this.bundleLevelThreshold) continue;
            String name = this.getNameToShow(info) + this.printFragments(info) + this.printHosts(info);
            String version = info.getVersion();
            table.addRow().addContent(new Object[]{info.getBundleId(), this.getStateString(info.getState()), info.getStartLevel(), version, name});
        }
        table.print(System.out, !this.noFormat);
        return null;
    }

    private String getNameHeader() {
        String msg = "Name";
        if (this.showLoc) {
            msg = "Location";
        } else if (this.showSymbolic) {
            msg = "Symbolic name";
        } else if (this.showUpdate) {
            msg = "Update location";
        } else if (this.showRevisions) {
            msg = "Revisions";
        }
        return msg;
    }

    private void determineBundleLevelThreshold() {
        String sbslProp = this.bundleContext.getProperty("karaf.systemBundlesStartLevel");
        if (sbslProp != null) {
            try {
                if (this.bundleLevelThreshold < 0) {
                    this.bundleLevelThreshold = Integer.valueOf(sbslProp);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String printHosts(BundleInfo info) {
        if (info.getFragmentHosts().size() <= 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(", Hosts: ");
        boolean first = true;
        for (Bundle host : info.getFragmentHosts()) {
            builder.append((first ? "" : ", ") + host.getBundleId());
            first = false;
        }
        return builder.toString();
    }

    private String printFragments(BundleInfo info) {
        if (info.getFragments().size() <= 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(", Fragments: ");
        boolean first = true;
        for (Bundle host : info.getFragments()) {
            builder.append((first ? "" : ", ") + host.getBundleId());
            first = false;
        }
        return builder.toString();
    }

    private String getStateString(BundleState state) {
        return state == null ? "" : state.toString();
    }

    private String getNameToShow(BundleInfo info) {
        if (this.showLoc) {
            return info.getUpdateLocation();
        }
        if (this.showSymbolic) {
            return info.getSymbolicName() == null ? "<no symbolic name>" : info.getSymbolicName();
        }
        if (this.showUpdate) {
            return info.getUpdateLocation();
        }
        if (this.showRevisions) {
            return info.getRevisions();
        }
        String name = info.getName() == null ? info.getSymbolicName() : info.getName();
        return name == null ? info.getUpdateLocation() : name;
    }
}

