/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.history.DurationReportResult;
import org.camunda.bpm.engine.history.HistoricProcessInstanceReport;
import org.camunda.bpm.engine.impl.AbstractReport;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.CompareUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class HistoricProcessInstanceReportImpl
extends AbstractReport
implements HistoricProcessInstanceReport {
    private static final long serialVersionUID = 1L;
    protected Date startedAfter;
    protected Date startedBefore;
    protected String[] processDefinitionIdIn;
    protected String[] processDefinitionKeyIn;

    public HistoricProcessInstanceReportImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public HistoricProcessInstanceReport startedAfter(Date startedAfter) {
        EnsureUtil.ensureNotNull(NotValidException.class, "startedAfter", (Object)startedAfter);
        this.startedAfter = startedAfter;
        return this;
    }

    @Override
    public HistoricProcessInstanceReport startedBefore(Date startedBefore) {
        EnsureUtil.ensureNotNull(NotValidException.class, "startedBefore", (Object)startedBefore);
        this.startedBefore = startedBefore;
        return this;
    }

    @Override
    public HistoricProcessInstanceReport processDefinitionIdIn(String ... processDefinitionIds) {
        EnsureUtil.ensureNotNull(NotValidException.class, "", "processDefinitionIdIn", (Object[])processDefinitionIds);
        this.processDefinitionIdIn = processDefinitionIds;
        return this;
    }

    @Override
    public HistoricProcessInstanceReport processDefinitionKeyIn(String ... processDefinitionKeys) {
        EnsureUtil.ensureNotNull(NotValidException.class, "", "processDefinitionKeyIn", (Object[])processDefinitionKeys);
        this.processDefinitionKeyIn = processDefinitionKeys;
        return this;
    }

    @Override
    protected boolean hasExcludingConditions() {
        return CompareUtil.areNotInAscendingOrder((Comparable[])new Date[]{this.startedAfter, this.startedBefore});
    }

    @Override
    public List<DurationReportResult> executeDurationReport(CommandContext commandContext) {
        return commandContext.getHistoricReportManager().createHistoricProcessInstanceDurationReport(this);
    }

    public Date getStartedAfter() {
        return this.startedAfter;
    }

    public Date getStartedBefore() {
        return this.startedBefore;
    }

    public String[] getProcessDefinitionIdIn() {
        return this.processDefinitionIdIn;
    }

    public String[] getProcessDefinitionKeyIn() {
        return this.processDefinitionKeyIn;
    }
}

