/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.impl.MessageCorrelationBuilderImpl;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.cmd.MessageEventReceivedCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.runtime.MessageCorrelationResult;
import org.camunda.bpm.engine.runtime.ProcessInstance;

public abstract class AbstractCorrelateMessageCmd {
    protected final String messageName;
    protected final MessageCorrelationBuilderImpl builder;

    protected AbstractCorrelateMessageCmd(MessageCorrelationBuilderImpl builder) {
        this.builder = builder;
        this.messageName = builder.getMessageName();
    }

    protected void triggerExecution(CommandContext commandContext, MessageCorrelationResult correlationResult) {
        String executionId = correlationResult.getExecutionEntity().getId();
        MessageEventReceivedCmd command = new MessageEventReceivedCmd(this.messageName, executionId, this.builder.getPayloadProcessInstanceVariables(), this.builder.isExclusiveCorrelation());
        command.execute(commandContext);
    }

    protected ProcessInstance instantiateProcess(CommandContext commandContext, MessageCorrelationResult correlationResult) {
        ProcessDefinitionEntity processDefinitionEntity = correlationResult.getProcessDefinitionEntity();
        ActivityImpl messageStartEvent = processDefinitionEntity.findActivity(correlationResult.getStartEventActivityId());
        ExecutionEntity processInstance = processDefinitionEntity.createProcessInstance(this.builder.getBusinessKey(), messageStartEvent);
        processInstance.start(this.builder.getPayloadProcessInstanceVariables());
        return processInstance;
    }

    protected void checkAuthorization(MessageCorrelationResult correlation) {
        CommandContext commandContext = Context.getCommandContext();
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            if ("execution".equals(correlation.getResultType())) {
                ExecutionEntity execution = correlation.getExecutionEntity();
                checker.checkUpdateProcessInstanceById(execution.getProcessInstanceId());
                continue;
            }
            ProcessDefinitionEntity definition = correlation.getProcessDefinitionEntity();
            checker.checkCreateProcessInstance(definition);
        }
    }
}

