/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.RowBounds;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricCaseActivityInstance;
import org.camunda.bpm.engine.history.HistoricCaseInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricFormProperty;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.TablePageQueryImpl;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricDetailEventEntity;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.AttachmentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.CommentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.FilterEntity;
import org.camunda.bpm.engine.impl.persistence.entity.GroupEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricCaseActivityInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricCaseInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricFormPropertyEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricIdentityLinkLogEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.IdentityInfoEntity;
import org.camunda.bpm.engine.impl.persistence.entity.IdentityLinkEntity;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MembershipEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TimerEntity;
import org.camunda.bpm.engine.impl.persistence.entity.UserEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.management.TableMetaData;
import org.camunda.bpm.engine.management.TablePage;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;

public class TableDataManager
extends AbstractManager {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    public static Map<Class<?>, String> apiTypeToTableNameMap = new HashMap();
    public static Map<Class<? extends DbEntity>, String> persistentObjectToTableNameMap = new HashMap<Class<? extends DbEntity>, String>();

    public Map<String, Long> getTableCount() {
        HashMap<String, Long> tableCount = new HashMap<String, Long>();
        try {
            for (String tableName : this.getDbEntityManager().getTableNamesPresentInDatabase()) {
                tableCount.put(tableName, this.getTableCount(tableName));
            }
            LOG.countRowsPerProcessEngineTable(tableCount);
        }
        catch (Exception e) {
            throw LOG.countTableRowsException(e);
        }
        return tableCount;
    }

    protected long getTableCount(String tableName) {
        LOG.selectTableCountForTable(tableName);
        Long count = (Long)this.getDbEntityManager().selectOne("selectTableCount", Collections.singletonMap("tableName", tableName));
        return count;
    }

    public TablePage getTablePage(TablePageQueryImpl tablePageQuery, int firstResult, int maxResults) {
        TablePage tablePage = new TablePage();
        List tableData = this.getDbSqlSession().getSqlSession().selectList("selectTableData", (Object)tablePageQuery, new RowBounds(firstResult, maxResults));
        tablePage.setTableName(tablePageQuery.getTableName());
        tablePage.setTotal(this.getTableCount(tablePageQuery.getTableName()));
        tablePage.setRows(tableData);
        tablePage.setFirstResult(firstResult);
        return tablePage;
    }

    public String getTableName(Class<?> entityClass, boolean withPrefix) {
        String databaseTablePrefix = this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseTablePrefix();
        String tableName = null;
        tableName = DbEntity.class.isAssignableFrom(entityClass) ? persistentObjectToTableNameMap.get(entityClass) : apiTypeToTableNameMap.get(entityClass);
        if (withPrefix) {
            return databaseTablePrefix + tableName;
        }
        return tableName;
    }

    public TableMetaData getTableMetaData(String tableName) {
        TableMetaData result = new TableMetaData();
        ResultSet resultSet = null;
        try {
            try {
                result.setTableName(tableName);
                DatabaseMetaData metaData = this.getDbSqlSession().getSqlSession().getConnection().getMetaData();
                if ("postgres".equals(this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseType())) {
                    tableName = tableName.toLowerCase();
                }
                resultSet = metaData.getColumns(null, null, tableName, null);
                while (resultSet.next()) {
                    String name = resultSet.getString("COLUMN_NAME").toUpperCase();
                    String type = resultSet.getString("TYPE_NAME").toUpperCase();
                    result.addColumnMetaData(name, type);
                }
            }
            catch (SQLException se) {
                throw se;
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            throw LOG.retrieveMetadataException(e);
        }
        if (result.getColumnNames().size() == 0) {
            result = null;
        }
        return result;
    }

    static {
        persistentObjectToTableNameMap.put(TaskEntity.class, "ACT_RU_TASK");
        persistentObjectToTableNameMap.put(ExecutionEntity.class, "ACT_RU_EXECUTION");
        persistentObjectToTableNameMap.put(IdentityLinkEntity.class, "ACT_RU_IDENTITYLINK");
        persistentObjectToTableNameMap.put(VariableInstanceEntity.class, "ACT_RU_VARIABLE");
        persistentObjectToTableNameMap.put(JobEntity.class, "ACT_RU_JOB");
        persistentObjectToTableNameMap.put(MessageEntity.class, "ACT_RU_JOB");
        persistentObjectToTableNameMap.put(TimerEntity.class, "ACT_RU_JOB");
        persistentObjectToTableNameMap.put(IncidentEntity.class, "ACT_RU_INCIDENT");
        persistentObjectToTableNameMap.put(EventSubscriptionEntity.class, "ACT_RU_EVENT_SUBSCRIPTION");
        persistentObjectToTableNameMap.put(CompensateEventSubscriptionEntity.class, "ACT_RU_EVENT_SUBSCRIPTION");
        persistentObjectToTableNameMap.put(MessageEventSubscriptionEntity.class, "ACT_RU_EVENT_SUBSCRIPTION");
        persistentObjectToTableNameMap.put(SignalEventSubscriptionEntity.class, "ACT_RU_EVENT_SUBSCRIPTION");
        persistentObjectToTableNameMap.put(FilterEntity.class, "ACT_RU_FILTER");
        persistentObjectToTableNameMap.put(DeploymentEntity.class, "ACT_RE_DEPLOYMENT");
        persistentObjectToTableNameMap.put(ProcessDefinitionEntity.class, "ACT_RE_PROCDEF");
        persistentObjectToTableNameMap.put(CommentEntity.class, "ACT_HI_COMMENT");
        persistentObjectToTableNameMap.put(HistoricActivityInstanceEntity.class, "ACT_HI_ACTINST");
        persistentObjectToTableNameMap.put(AttachmentEntity.class, "ACT_HI_ATTACHMENT");
        persistentObjectToTableNameMap.put(HistoricProcessInstanceEntity.class, "ACT_HI_PROCINST");
        persistentObjectToTableNameMap.put(HistoricTaskInstanceEntity.class, "ACT_HI_TASKINST");
        persistentObjectToTableNameMap.put(HistoricCaseInstanceEntity.class, "ACT_HI_CASEINST");
        persistentObjectToTableNameMap.put(HistoricCaseActivityInstanceEntity.class, "ACT_HI_CASEACTINST");
        persistentObjectToTableNameMap.put(HistoricIdentityLinkLogEntity.class, "ACT_HI_IDENTITYLINK");
        persistentObjectToTableNameMap.put(HistoricFormPropertyEntity.class, "ACT_HI_DETAIL");
        persistentObjectToTableNameMap.put(HistoricVariableInstanceEntity.class, "ACT_HI_DETAIL");
        persistentObjectToTableNameMap.put(HistoricDetailEventEntity.class, "ACT_HI_DETAIL");
        persistentObjectToTableNameMap.put(HistoricDecisionInstanceEntity.class, "ACT_HI_DECINST");
        persistentObjectToTableNameMap.put(GroupEntity.class, "ACT_ID_GROUP");
        persistentObjectToTableNameMap.put(MembershipEntity.class, "ACT_ID_MEMBERSHIP");
        persistentObjectToTableNameMap.put(UserEntity.class, "ACT_ID_USER");
        persistentObjectToTableNameMap.put(IdentityInfoEntity.class, "ACT_ID_INFO");
        persistentObjectToTableNameMap.put(PropertyEntity.class, "ACT_GE_PROPERTY");
        persistentObjectToTableNameMap.put(ByteArrayEntity.class, "ACT_GE_BYTEARRAY");
        persistentObjectToTableNameMap.put(ResourceEntity.class, "ACT_GE_BYTEARRAY");
        apiTypeToTableNameMap.put(Task.class, "ACT_RU_TASK");
        apiTypeToTableNameMap.put(Execution.class, "ACT_RU_EXECUTION");
        apiTypeToTableNameMap.put(ProcessInstance.class, "ACT_RU_EXECUTION");
        apiTypeToTableNameMap.put(ProcessDefinition.class, "ACT_RE_PROCDEF");
        apiTypeToTableNameMap.put(Deployment.class, "ACT_RE_DEPLOYMENT");
        apiTypeToTableNameMap.put(Job.class, "ACT_RU_JOB");
        apiTypeToTableNameMap.put(Incident.class, "ACT_RU_INCIDENT");
        apiTypeToTableNameMap.put(Filter.class, "ACT_RU_FILTER");
        apiTypeToTableNameMap.put(HistoricProcessInstance.class, "ACT_HI_PROCINST");
        apiTypeToTableNameMap.put(HistoricActivityInstance.class, "ACT_HI_ACTINST");
        apiTypeToTableNameMap.put(HistoricDetail.class, "ACT_HI_DETAIL");
        apiTypeToTableNameMap.put(HistoricVariableUpdate.class, "ACT_HI_DETAIL");
        apiTypeToTableNameMap.put(HistoricFormProperty.class, "ACT_HI_DETAIL");
        apiTypeToTableNameMap.put(HistoricTaskInstance.class, "ACT_HI_TASKINST");
        apiTypeToTableNameMap.put(HistoricVariableInstance.class, "ACT_HI_VARINST");
        apiTypeToTableNameMap.put(HistoricCaseInstance.class, "ACT_HI_CASEINST");
        apiTypeToTableNameMap.put(HistoricCaseActivityInstance.class, "ACT_HI_CASEACTINST");
        apiTypeToTableNameMap.put(HistoricDecisionInstance.class, "ACT_HI_DECINST");
    }
}

