/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.bpmn.builder;

import org.camunda.bpm.model.bpmn.BpmnModelException;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.AbstractActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.AbstractFlowElementBuilder;
import org.camunda.bpm.model.bpmn.builder.AbstractGatewayBuilder;
import org.camunda.bpm.model.bpmn.builder.BusinessRuleTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.EndEventBuilder;
import org.camunda.bpm.model.bpmn.builder.EventBasedGatewayBuilder;
import org.camunda.bpm.model.bpmn.builder.ExclusiveGatewayBuilder;
import org.camunda.bpm.model.bpmn.builder.InclusiveGatewayBuilder;
import org.camunda.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.camunda.bpm.model.bpmn.builder.IntermediateThrowEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ManualTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.ParallelGatewayBuilder;
import org.camunda.bpm.model.bpmn.builder.ReceiveTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.ScriptTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.SendTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.SequenceFlowBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.TransactionBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.camunda.bpm.model.bpmn.instance.Activity;
import org.camunda.bpm.model.bpmn.instance.BusinessRuleTask;
import org.camunda.bpm.model.bpmn.instance.CallActivity;
import org.camunda.bpm.model.bpmn.instance.ConditionExpression;
import org.camunda.bpm.model.bpmn.instance.EndEvent;
import org.camunda.bpm.model.bpmn.instance.EventBasedGateway;
import org.camunda.bpm.model.bpmn.instance.ExclusiveGateway;
import org.camunda.bpm.model.bpmn.instance.FlowNode;
import org.camunda.bpm.model.bpmn.instance.Gateway;
import org.camunda.bpm.model.bpmn.instance.InclusiveGateway;
import org.camunda.bpm.model.bpmn.instance.IntermediateCatchEvent;
import org.camunda.bpm.model.bpmn.instance.IntermediateThrowEvent;
import org.camunda.bpm.model.bpmn.instance.ManualTask;
import org.camunda.bpm.model.bpmn.instance.ParallelGateway;
import org.camunda.bpm.model.bpmn.instance.ReceiveTask;
import org.camunda.bpm.model.bpmn.instance.ScriptTask;
import org.camunda.bpm.model.bpmn.instance.SendTask;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.camunda.bpm.model.bpmn.instance.ServiceTask;
import org.camunda.bpm.model.bpmn.instance.SubProcess;
import org.camunda.bpm.model.bpmn.instance.Transaction;
import org.camunda.bpm.model.bpmn.instance.UserTask;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaExecutionListener;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaFailedJobRetryTimeCycle;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public abstract class AbstractFlowNodeBuilder<B extends AbstractFlowNodeBuilder<B, E>, E extends FlowNode>
extends AbstractFlowElementBuilder<B, E> {
    private SequenceFlowBuilder currentSequenceFlowBuilder;

    protected AbstractFlowNodeBuilder(BpmnModelInstance modelInstance, E element, Class<?> selfType) {
        super(modelInstance, element, selfType);
    }

    private SequenceFlowBuilder getCurrentSequenceFlowBuilder() {
        if (this.currentSequenceFlowBuilder == null) {
            SequenceFlow sequenceFlow = this.createSibling(SequenceFlow.class);
            this.currentSequenceFlowBuilder = sequenceFlow.builder();
        }
        return this.currentSequenceFlowBuilder;
    }

    public B condition(String name, String condition) {
        if (name != null) {
            this.getCurrentSequenceFlowBuilder().name(name);
        }
        ConditionExpression conditionExpression = this.createInstance(ConditionExpression.class);
        conditionExpression.setTextContent(condition);
        this.getCurrentSequenceFlowBuilder().condition(conditionExpression);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }

    private void connectTarget(FlowNode target) {
        ((SequenceFlowBuilder)this.getCurrentSequenceFlowBuilder().from((FlowNode)this.element)).to(target);
        this.currentSequenceFlowBuilder = null;
    }

    public B sequenceFlowId(String sequenceFlowId) {
        this.getCurrentSequenceFlowBuilder().id(sequenceFlowId);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }

    private <T extends FlowNode> T createTarget(Class<T> typeClass) {
        return this.createTarget(typeClass, null);
    }

    private <T extends FlowNode> T createTarget(Class<T> typeClass, String identifier) {
        FlowNode target = (FlowNode)this.createSibling(typeClass, identifier);
        this.connectTarget(target);
        return (T)target;
    }

    public ServiceTaskBuilder serviceTask() {
        return this.createTarget(ServiceTask.class).builder();
    }

    public ServiceTaskBuilder serviceTask(String id) {
        return this.createTarget(ServiceTask.class, id).builder();
    }

    public SendTaskBuilder sendTask() {
        return this.createTarget(SendTask.class).builder();
    }

    public SendTaskBuilder sendTask(String id) {
        return this.createTarget(SendTask.class, id).builder();
    }

    public UserTaskBuilder userTask() {
        return this.createTarget(UserTask.class).builder();
    }

    public UserTaskBuilder userTask(String id) {
        return this.createTarget(UserTask.class, id).builder();
    }

    public BusinessRuleTaskBuilder businessRuleTask() {
        return this.createTarget(BusinessRuleTask.class).builder();
    }

    public BusinessRuleTaskBuilder businessRuleTask(String id) {
        return this.createTarget(BusinessRuleTask.class, id).builder();
    }

    public ScriptTaskBuilder scriptTask() {
        return this.createTarget(ScriptTask.class).builder();
    }

    public ScriptTaskBuilder scriptTask(String id) {
        return this.createTarget(ScriptTask.class, id).builder();
    }

    public ReceiveTaskBuilder receiveTask() {
        return this.createTarget(ReceiveTask.class).builder();
    }

    public ReceiveTaskBuilder receiveTask(String id) {
        return this.createTarget(ReceiveTask.class, id).builder();
    }

    public ManualTaskBuilder manualTask() {
        return this.createTarget(ManualTask.class).builder();
    }

    public ManualTaskBuilder manualTask(String id) {
        return this.createTarget(ManualTask.class, id).builder();
    }

    public EndEventBuilder endEvent() {
        return this.createTarget(EndEvent.class).builder();
    }

    public EndEventBuilder endEvent(String id) {
        return this.createTarget(EndEvent.class, id).builder();
    }

    public ParallelGatewayBuilder parallelGateway() {
        return this.createTarget(ParallelGateway.class).builder();
    }

    public ParallelGatewayBuilder parallelGateway(String id) {
        return this.createTarget(ParallelGateway.class, id).builder();
    }

    public ExclusiveGatewayBuilder exclusiveGateway() {
        return this.createTarget(ExclusiveGateway.class).builder();
    }

    public InclusiveGatewayBuilder inclusiveGateway() {
        return this.createTarget(InclusiveGateway.class).builder();
    }

    public EventBasedGatewayBuilder eventBasedGateway() {
        return this.createTarget(EventBasedGateway.class).builder();
    }

    public ExclusiveGatewayBuilder exclusiveGateway(String id) {
        return this.createTarget(ExclusiveGateway.class, id).builder();
    }

    public InclusiveGatewayBuilder inclusiveGateway(String id) {
        return this.createTarget(InclusiveGateway.class, id).builder();
    }

    public IntermediateCatchEventBuilder intermediateCatchEvent() {
        return this.createTarget(IntermediateCatchEvent.class).builder();
    }

    public IntermediateCatchEventBuilder intermediateCatchEvent(String id) {
        return this.createTarget(IntermediateCatchEvent.class, id).builder();
    }

    public IntermediateThrowEventBuilder intermediateThrowEvent() {
        return this.createTarget(IntermediateThrowEvent.class).builder();
    }

    public IntermediateThrowEventBuilder intermediateThrowEvent(String id) {
        return this.createTarget(IntermediateThrowEvent.class, id).builder();
    }

    public CallActivityBuilder callActivity() {
        return this.createTarget(CallActivity.class).builder();
    }

    public CallActivityBuilder callActivity(String id) {
        return this.createTarget(CallActivity.class, id).builder();
    }

    public SubProcessBuilder subProcess() {
        return this.createTarget(SubProcess.class).builder();
    }

    public SubProcessBuilder subProcess(String id) {
        return this.createTarget(SubProcess.class, id).builder();
    }

    public TransactionBuilder transaction() {
        Transaction transaction = this.createTarget(Transaction.class);
        return new TransactionBuilder(this.modelInstance, transaction);
    }

    public TransactionBuilder transaction(String id) {
        Transaction transaction = this.createTarget(Transaction.class, id);
        return new TransactionBuilder(this.modelInstance, transaction);
    }

    public Gateway findLastGateway() {
        FlowNode lastGateway = (FlowNode)this.element;
        try {
            while (!((lastGateway = lastGateway.getPreviousNodes().singleResult()) instanceof Gateway)) {
            }
            return (Gateway)lastGateway;
        }
        catch (BpmnModelException e) {
            throw new BpmnModelException("Unable to determine an unique previous gateway of " + lastGateway.getId(), (Throwable)((Object)e));
        }
    }

    public AbstractGatewayBuilder moveToLastGateway() {
        return this.findLastGateway().builder();
    }

    public AbstractFlowNodeBuilder moveToNode(String identifier) {
        ModelElementInstance instance = this.modelInstance.getModelElementById(identifier);
        if (instance != null && instance instanceof FlowNode) {
            return ((FlowNode)instance).builder();
        }
        throw new BpmnModelException("Flow node not found for id " + identifier);
    }

    public <T extends AbstractActivityBuilder> T moveToActivity(String identifier) {
        ModelElementInstance instance = this.modelInstance.getModelElementById(identifier);
        if (instance != null && instance instanceof Activity) {
            return (T)((AbstractActivityBuilder)((Activity)instance).builder());
        }
        throw new BpmnModelException("Activity not found for id " + identifier);
    }

    public AbstractFlowNodeBuilder connectTo(String identifier) {
        ModelElementInstance target = this.modelInstance.getModelElementById(identifier);
        if (target == null) {
            throw new BpmnModelException("Unable to connect " + ((FlowNode)this.element).getId() + " to element " + identifier + " cause it not exists.");
        }
        if (!(target instanceof FlowNode)) {
            throw new BpmnModelException("Unable to connect " + ((FlowNode)this.element).getId() + " to element " + identifier + " cause its not a flow node.");
        }
        FlowNode targetNode = (FlowNode)target;
        this.connectTarget(targetNode);
        return targetNode.builder();
    }

    public B camundaAsyncBefore(boolean asyncBefore) {
        ((FlowNode)this.element).setCamundaAsyncBefore(asyncBefore);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }

    public B camundaAsyncBefore() {
        ((FlowNode)this.element).setCamundaAsyncBefore(true);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }

    public B camundaAsyncAfter(boolean asyncAfter) {
        ((FlowNode)this.element).setCamundaAsyncAfter(asyncAfter);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }

    public B camundaAsyncAfter() {
        ((FlowNode)this.element).setCamundaAsyncAfter(true);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }

    public B notCamundaExclusive() {
        ((FlowNode)this.element).setCamundaExclusive(false);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }

    public B camundaExclusive(boolean exclusive) {
        ((FlowNode)this.element).setCamundaExclusive(exclusive);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }

    public B camundaJobPriority(String jobPriority) {
        ((FlowNode)this.element).setCamundaJobPriority(jobPriority);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }

    public B camundaFailedJobRetryTimeCycle(String retryTimeCycle) {
        CamundaFailedJobRetryTimeCycle failedJobRetryTimeCycle = this.createInstance(CamundaFailedJobRetryTimeCycle.class);
        failedJobRetryTimeCycle.setTextContent(retryTimeCycle);
        this.addExtensionElement(failedJobRetryTimeCycle);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }

    public B camundaExecutionListenerClass(String eventName, String fullQualifiedClassName) {
        CamundaExecutionListener executionListener = this.createInstance(CamundaExecutionListener.class);
        executionListener.setCamundaEvent(eventName);
        executionListener.setCamundaClass(fullQualifiedClassName);
        this.addExtensionElement(executionListener);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }

    public B camundaExecutionListenerExpression(String eventName, String expression) {
        CamundaExecutionListener executionListener = this.createInstance(CamundaExecutionListener.class);
        executionListener.setCamundaEvent(eventName);
        executionListener.setCamundaExpression(expression);
        this.addExtensionElement(executionListener);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }

    public B camundaExecutionListenerDelegateExpression(String eventName, String delegateExpression) {
        CamundaExecutionListener executionListener = this.createInstance(CamundaExecutionListener.class);
        executionListener.setCamundaEvent(eventName);
        executionListener.setCamundaDelegateExpression(delegateExpression);
        this.addExtensionElement(executionListener);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }
}

