/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.osgi.scripting.impl;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.camunda.bpm.extension.osgi.scripting.ScriptEngineResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;

public class BundleScriptEngineResolver
implements ScriptEngineResolver {
    private static final Logger LOGGER = Logger.getLogger(BundleScriptEngineResolver.class.getName());
    private final Bundle bundle;
    private ServiceRegistration<ScriptEngineResolver> reg;
    private final URL configFile;

    public BundleScriptEngineResolver(Bundle bundle, URL configFile) {
        this.bundle = bundle;
        this.configFile = configFile;
    }

    public void register() {
        if (this.bundle.getBundleContext() != null) {
            this.reg = this.bundle.getBundleContext().registerService(ScriptEngineResolver.class, (Object)this, null);
        }
    }

    public void unregister() {
        if (this.reg != null) {
            this.reg.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptEngine resolveScriptEngine(String name) {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(this.configFile.openStream()));
            String className = in.readLine();
            in.close();
            Class cls = this.bundle.loadClass(className);
            if (!ScriptEngineFactory.class.isAssignableFrom(cls)) {
                throw new IllegalStateException("Invalid ScriptEngineFactory: " + cls.getName());
            }
            ScriptEngineFactory factory = (ScriptEngineFactory)cls.newInstance();
            List<String> names = factory.getNames();
            for (String n : names) {
                ScriptEngine engine;
                if (!n.equals(name)) continue;
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(factory.getClass().getClassLoader());
                    engine = factory.getScriptEngine();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
                LOGGER.finest("Resolved ScriptEngineFactory: " + engine + " for expected name: " + name);
                return engine;
            }
            LOGGER.fine("ScriptEngineFactory: " + factory.getEngineName() + " does not match expected name: " + name);
            return null;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Cannot create ScriptEngineFactory: " + e.getClass().getName(), e);
            return null;
        }
    }

    public String toString() {
        return "OSGi script engine resolver for " + this.bundle.getSymbolicName();
    }
}

