/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl.index;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.dm.FilterIndex;
import org.apache.felix.dm.impl.Logger;
import org.apache.felix.dm.impl.index.BundleContextInterceptorBase;
import org.apache.felix.dm.impl.index.ServiceRegistryCache;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class BundleContextInterceptor
extends BundleContextInterceptorBase {
    protected static final String INDEX_LOG_TRESHOLD = "org.apache.felix.dm.index.log.treshold";
    private final ServiceRegistryCache m_cache;
    private final boolean m_perfmon = System.getProperty("org.apache.felix.dm.index.log.treshold") != null;
    private Logger m_logger;
    private long m_treshold;

    public BundleContextInterceptor(ServiceRegistryCache cache, BundleContext context) {
        super(context);
        this.m_cache = cache;
        if (this.m_perfmon) {
            this.m_treshold = Long.parseLong(System.getProperty(INDEX_LOG_TRESHOLD));
            this.m_logger = new Logger(context);
        }
    }

    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        FilterIndex filterIndex = this.m_cache.hasFilterIndexFor(null, filter);
        if (filterIndex != null) {
            filterIndex.addServiceListener(listener, filter);
        } else {
            this.m_context.addServiceListener(listener, filter);
        }
    }

    public void addServiceListener(ServiceListener listener) {
        FilterIndex filterIndex = this.m_cache.hasFilterIndexFor(null, null);
        if (filterIndex != null) {
            filterIndex.addServiceListener(listener, null);
        } else {
            this.m_context.addServiceListener(listener);
        }
    }

    public void removeServiceListener(ServiceListener listener) {
        Iterator filterIndexIterator = this.m_cache.getFilterIndices().iterator();
        while (filterIndexIterator.hasNext()) {
            ((FilterIndex)filterIndexIterator.next()).removeServiceListener(listener);
        }
        this.m_context.removeServiceListener(listener);
    }

    public ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        long duration;
        FilterIndex filterIndex;
        long start = 0L;
        if (this.m_perfmon) {
            start = System.currentTimeMillis();
        }
        if ((filterIndex = this.m_cache.hasFilterIndexFor(clazz, filter)) != null) {
            long duration2;
            List result = filterIndex.getAllServiceReferences(clazz, filter);
            Iterator iterator = result.iterator();
            block0: while (iterator.hasNext()) {
                ServiceReference reference = (ServiceReference)iterator.next();
                String[] list = (String[])reference.getProperty("objectClass");
                for (int i = 0; i < list.length; ++i) {
                    if (reference.isAssignableTo(this.m_context.getBundle(), list[i])) continue;
                    iterator.remove();
                    continue block0;
                }
            }
            if (this.m_perfmon && (duration2 = System.currentTimeMillis() - start) > this.m_treshold) {
                this.m_logger.log(4, "Indexed filter exceeds lookup time treshold (" + duration2 + "ms.): " + clazz + " " + filter);
            }
            if (result == null || result.size() == 0) {
                return null;
            }
            return result.toArray(new ServiceReference[result.size()]);
        }
        ServiceReference[] serviceReferences = this.m_context.getServiceReferences(clazz, filter);
        if (this.m_perfmon && (duration = System.currentTimeMillis() - start) > this.m_treshold) {
            this.m_logger.log(4, "Unindexed filter exceeds lookup time treshold (" + duration + "ms.): " + clazz + " " + filter);
        }
        return serviceReferences;
    }

    public ServiceReference[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        FilterIndex filterIndex = this.m_cache.hasFilterIndexFor(clazz, filter);
        if (filterIndex != null) {
            List result = filterIndex.getAllServiceReferences(clazz, filter);
            if (result == null || result.size() == 0) {
                return null;
            }
            return result.toArray(new ServiceReference[result.size()]);
        }
        return this.m_context.getAllServiceReferences(clazz, filter);
    }

    public ServiceReference getServiceReference(String clazz) {
        try {
            Object[] references = this.getServiceReferences(clazz, null);
            if (references == null || references.length == 0) {
                return null;
            }
            Arrays.sort(references);
            return references[references.length - 1];
        }
        catch (InvalidSyntaxException e) {
            throw new Error("Invalid filter syntax thrown for null filter.", e);
        }
    }

    public void serviceChanged(ServiceEvent event) {
        this.m_cache.serviceChangedForFilterIndices(event);
    }
}

