/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.feel.impl.juel;

import camundafeel.javax.el.ELContext;
import camundafeel.javax.el.ELException;
import camundafeel.javax.el.ExpressionFactory;
import camundafeel.javax.el.ValueExpression;
import org.camunda.bpm.dmn.feel.impl.FeelEngine;
import org.camunda.bpm.dmn.feel.impl.juel.FeelConvertException;
import org.camunda.bpm.dmn.feel.impl.juel.FeelEngineLogger;
import org.camunda.bpm.dmn.feel.impl.juel.FeelLogger;
import org.camunda.bpm.dmn.feel.impl.juel.FeelMethodInvocationException;
import org.camunda.bpm.dmn.feel.impl.juel.FeelMissingFunctionException;
import org.camunda.bpm.dmn.feel.impl.juel.FeelMissingVariableException;
import org.camunda.bpm.dmn.feel.impl.juel.el.ElContextFactory;
import org.camunda.bpm.dmn.feel.impl.juel.transform.FeelToJuelTransform;
import org.camunda.bpm.engine.variable.context.VariableContext;

public class FeelEngineImpl
implements FeelEngine {
    public static final FeelEngineLogger LOG = FeelLogger.ENGINE_LOGGER;
    protected FeelToJuelTransform transform;
    protected ExpressionFactory expressionFactory;
    protected ElContextFactory elContextFactory;

    public FeelEngineImpl(FeelToJuelTransform transform, ExpressionFactory expressionFactory, ElContextFactory elContextFactory) {
        this.transform = transform;
        this.expressionFactory = expressionFactory;
        this.elContextFactory = elContextFactory;
    }

    public <T> T evaluateSimpleExpression(String simpleExpression, VariableContext variableContext) {
        throw LOG.simpleExpressionNotSupported();
    }

    public boolean evaluateSimpleUnaryTests(String simpleUnaryTests, String inputName, VariableContext variableContext) {
        try {
            ELContext elContext = this.createContext(variableContext);
            ValueExpression valueExpression = this.transformSimpleUnaryTests(simpleUnaryTests, inputName, elContext);
            return (Boolean)valueExpression.getValue(elContext);
        }
        catch (FeelMissingFunctionException e) {
            throw LOG.unknownFunction(simpleUnaryTests, e);
        }
        catch (FeelMissingVariableException e) {
            if (inputName.equals(e.getVariable())) {
                throw LOG.unableToEvaluateExpressionAsNotInputIsSet(simpleUnaryTests, e);
            }
            throw LOG.unknownVariable(simpleUnaryTests, e);
        }
        catch (FeelConvertException e) {
            throw LOG.unableToConvertValue(simpleUnaryTests, e);
        }
        catch (ELException e) {
            if (e.getCause() instanceof FeelMethodInvocationException) {
                throw LOG.unableToInvokeMethod(simpleUnaryTests, (FeelMethodInvocationException)((Object)e.getCause()));
            }
            throw LOG.unableToEvaluateExpression(simpleUnaryTests, e);
        }
    }

    protected ELContext createContext(VariableContext variableContext) {
        return this.elContextFactory.createContext(this.expressionFactory, variableContext);
    }

    protected ValueExpression transformSimpleUnaryTests(String simpleUnaryTests, String inputName, ELContext elContext) {
        String juelExpression = this.transform.transformSimpleUnaryTests(simpleUnaryTests, inputName);
        try {
            return this.expressionFactory.createValueExpression(elContext, juelExpression, Object.class);
        }
        catch (ELException e) {
            throw LOG.invalidExpression(simpleUnaryTests, e);
        }
    }
}

