/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.feel.impl.juel;

import camundafeel.de.odysseus.el.ExpressionFactoryImpl;
import camundafeel.de.odysseus.el.misc.TypeConverter;
import camundafeel.javax.el.ELException;
import camundafeel.javax.el.ExpressionFactory;
import java.util.Properties;
import org.camunda.bpm.dmn.feel.impl.FeelEngine;
import org.camunda.bpm.dmn.feel.impl.FeelEngineFactory;
import org.camunda.bpm.dmn.feel.impl.juel.FeelEngineImpl;
import org.camunda.bpm.dmn.feel.impl.juel.FeelEngineLogger;
import org.camunda.bpm.dmn.feel.impl.juel.FeelLogger;
import org.camunda.bpm.dmn.feel.impl.juel.TransformExpressionCacheKey;
import org.camunda.bpm.dmn.feel.impl.juel.el.ElContextFactory;
import org.camunda.bpm.dmn.feel.impl.juel.el.FeelElContextFactory;
import org.camunda.bpm.dmn.feel.impl.juel.el.FeelTypeConverter;
import org.camunda.bpm.dmn.feel.impl.juel.transform.FeelToJuelTransform;
import org.camunda.bpm.dmn.feel.impl.juel.transform.FeelToJuelTransformImpl;
import org.camunda.commons.utils.cache.Cache;
import org.camunda.commons.utils.cache.ConcurrentLruCache;

public class FeelEngineFactoryImpl
implements FeelEngineFactory {
    public static final FeelEngineLogger LOG = FeelLogger.ENGINE_LOGGER;
    public static final int DEFAULT_EXPRESSION_CACHE_SIZE = 1000;
    protected final FeelEngine feelEngine;
    protected final int expressionCacheSize;

    public FeelEngineFactoryImpl() {
        this(1000);
    }

    public FeelEngineFactoryImpl(int expressionCacheSize) {
        this.expressionCacheSize = expressionCacheSize;
        this.feelEngine = this.createFeelEngine();
    }

    public FeelEngine createInstance() {
        return this.feelEngine;
    }

    protected FeelEngine createFeelEngine() {
        FeelToJuelTransform transform = this.createFeelToJuelTransform();
        ExpressionFactory expressionFactory = this.createExpressionFactory();
        ElContextFactory elContextFactory = this.createElContextFactory();
        Cache<TransformExpressionCacheKey, String> transformExpressionCache = this.createTransformExpressionCache();
        return new FeelEngineImpl(transform, expressionFactory, elContextFactory, transformExpressionCache);
    }

    protected FeelToJuelTransform createFeelToJuelTransform() {
        return new FeelToJuelTransformImpl();
    }

    protected ExpressionFactory createExpressionFactory() {
        Properties properties = new Properties();
        properties.put("camundafeel.javax.el.cacheSize", String.valueOf(this.expressionCacheSize));
        try {
            return new ExpressionFactoryImpl(properties, (TypeConverter)this.createTypeConverter());
        }
        catch (ELException e) {
            throw LOG.unableToInitializeFeelEngine(e);
        }
    }

    protected FeelTypeConverter createTypeConverter() {
        return new FeelTypeConverter();
    }

    protected ElContextFactory createElContextFactory() {
        return new FeelElContextFactory();
    }

    protected Cache<TransformExpressionCacheKey, String> createTransformExpressionCache() {
        return new ConcurrentLruCache(this.expressionCacheSize);
    }
}

