/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.event;

import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.event.EventHandlerImpl;
import org.camunda.bpm.engine.impl.event.EventType;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmProcessInstance;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class SignalEventHandler
extends EventHandlerImpl {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;

    public SignalEventHandler() {
        super(EventType.SIGNAL);
    }

    protected void handleStartEvent(EventSubscriptionEntity eventSubscription, Object payload, CommandContext commandContext) {
        String processDefinitionId = eventSubscription.getConfiguration();
        EnsureUtil.ensureNotNull("Configuration of signal start event subscription '" + eventSubscription.getId() + "' contains no process definition id.", (Object)processDefinitionId);
        DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
        ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedProcessDefinitionById(processDefinitionId);
        if (processDefinition == null || processDefinition.isSuspended()) {
            LOG.debugIgnoringEventSubscription(eventSubscription, processDefinitionId);
        } else {
            ActivityImpl signalStartEvent = processDefinition.findActivity(eventSubscription.getActivityId());
            PvmProcessInstance processInstance = processDefinition.createProcessInstanceForInitial(signalStartEvent);
            processInstance.start();
        }
    }

    @Override
    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, CommandContext commandContext) {
        if (eventSubscription.getExecutionId() != null) {
            this.handleIntermediateEvent(eventSubscription, payload, commandContext);
        } else {
            this.handleStartEvent(eventSubscription, payload, commandContext);
        }
    }
}

