/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence;

import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.interceptor.Session;
import org.camunda.bpm.engine.impl.interceptor.SessionFactory;
import org.camunda.bpm.engine.impl.util.ReflectUtil;

public class GenericManagerFactory
implements SessionFactory {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    protected Class<? extends Session> managerImplementation;

    public GenericManagerFactory(Class<? extends Session> managerImplementation) {
        this.managerImplementation = managerImplementation;
    }

    public GenericManagerFactory(String classname) {
        this.managerImplementation = ReflectUtil.loadClass(classname);
    }

    @Override
    public Class<?> getSessionType() {
        return this.managerImplementation;
    }

    @Override
    public Session openSession() {
        try {
            return this.managerImplementation.newInstance();
        }
        catch (Exception e) {
            throw LOG.instantiateSessionException(this.managerImplementation.getName(), e);
        }
    }
}

