/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.jdbc;

import java.security.Principal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.karaf.jaas.boot.principal.GroupPrincipal;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.jaas.modules.encryption.EncryptionSupport;
import org.apache.karaf.jaas.modules.jdbc.JDBCUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCBackingEngine
implements BackingEngine {
    private final Logger logger = LoggerFactory.getLogger(JDBCBackingEngine.class);
    private DataSource dataSource;
    private EncryptionSupport encryptionSupport;
    private String addUserStatement = "INSERT INTO USERS VALUES(?,?)";
    private String addRoleStatement = "INSERT INTO ROLES VALUES(?,?)";
    private String deleteRoleStatement = "DELETE FROM ROLES WHERE USERNAME=? AND ROLE=?";
    private String deleteAllUserRolesStatement = "DELETE FROM ROLES WHERE USERNAME=?";
    private String deleteUserStatement = "DELETE FROM USERS WHERE USERNAME=?";
    private String selectUsersQuery = "SELECT USERNAME FROM USERS";
    private String selectRolesQuery = "SELECT ROLE FROM ROLES WHERE USERNAME=?";

    public JDBCBackingEngine(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public JDBCBackingEngine(DataSource dataSource, EncryptionSupport encryptionSupport) {
        this.dataSource = dataSource;
        this.encryptionSupport = encryptionSupport;
    }

    @Override
    public void addUser(String username, String password) {
        if (username.startsWith("_g_:")) {
            throw new IllegalArgumentException("Prefix not permitted: _g_:");
        }
        if (this.encryptionSupport != null && this.encryptionSupport.getEncryption() != null) {
            password = this.encryptionSupport.getEncryption().encryptPassword(password);
            if (this.encryptionSupport.getEncryptionPrefix() != null) {
                password = this.encryptionSupport.getEncryptionPrefix() + password;
            }
            if (this.encryptionSupport.getEncryptionSuffix() != null) {
                password = password + this.encryptionSupport.getEncryptionSuffix();
            }
        }
        try (Connection connection = this.dataSource.getConnection();){
            this.rawUpdate(connection, this.addUserStatement, username, password);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error adding user", e);
        }
    }

    @Override
    public void deleteUser(String username) {
        try (Connection connection = this.dataSource.getConnection();){
            this.rawUpdate(connection, this.deleteAllUserRolesStatement, username);
            this.rawUpdate(connection, this.deleteUserStatement, username);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error deleting user", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<UserPrincipal> listUsers() {
        try (Connection connection = this.dataSource.getConnection();){
            ArrayList<UserPrincipal> users = new ArrayList<UserPrincipal>();
            for (String name : this.rawSelect(connection, this.selectUsersQuery, new String[0])) {
                if (name.startsWith("_g_:")) continue;
                users.add(new UserPrincipal(name));
            }
            ArrayList<UserPrincipal> arrayList = users;
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error listing users", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<RolePrincipal> listRoles(Principal principal) {
        try (Connection connection = this.dataSource.getConnection();){
            if (principal instanceof GroupPrincipal) {
                List<RolePrincipal> list = this.listRoles(connection, "_g_:" + principal.getName());
                return list;
            }
            List<RolePrincipal> list = this.listRoles(connection, principal.getName());
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error listing roles", e);
        }
    }

    private List<RolePrincipal> listRoles(Connection connection, String name) throws SQLException {
        ArrayList<RolePrincipal> roles = new ArrayList<RolePrincipal>();
        for (String role : this.rawSelect(connection, this.selectRolesQuery, name)) {
            if (role.startsWith("_g_:")) {
                roles.addAll(this.listRoles(connection, role));
                continue;
            }
            roles.add(new RolePrincipal(role));
        }
        return roles;
    }

    @Override
    public void addRole(String username, String role) {
        try (Connection connection = this.dataSource.getConnection();){
            this.rawUpdate(connection, this.addRoleStatement, username, role);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error adding role", e);
        }
    }

    @Override
    public void deleteRole(String username, String role) {
        try (Connection connection = this.dataSource.getConnection();){
            this.rawUpdate(connection, this.deleteRoleStatement, username, role);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error deleting role", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<GroupPrincipal> listGroups(UserPrincipal principal) {
        try (Connection connection = this.dataSource.getConnection();){
            ArrayList<GroupPrincipal> roles = new ArrayList<GroupPrincipal>();
            for (String role : this.rawSelect(connection, this.selectRolesQuery, principal.getName())) {
                if (!role.startsWith("_g_:")) continue;
                roles.add(new GroupPrincipal(role.substring("_g_:".length())));
            }
            ArrayList<GroupPrincipal> arrayList = roles;
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error deleting role", e);
        }
    }

    @Override
    public void addGroup(String username, String group) {
        try (Connection connection = this.dataSource.getConnection();){
            String groupName = "_g_:" + group;
            this.rawUpdate(connection, this.addRoleStatement, username, groupName);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            this.logger.error("Error executing statement", (Throwable)e);
        }
    }

    @Override
    public void deleteGroup(String username, String group) {
        try (Connection connection = this.dataSource.getConnection();){
            this.rawUpdate(connection, this.deleteRoleStatement, username, "_g_:" + group);
            boolean inUse = false;
            block11: for (String user : this.rawSelect(connection, this.selectUsersQuery, new String[0])) {
                for (String g : this.rawSelect(connection, this.selectRolesQuery, user)) {
                    if (!group.equals(g)) continue;
                    inUse = true;
                    continue block11;
                }
            }
            if (!inUse) {
                this.rawUpdate(connection, this.deleteAllUserRolesStatement, "_g_:" + group);
            }
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            this.logger.error("Error executing statement", (Throwable)e);
        }
    }

    @Override
    public void addGroupRole(String group, String role) {
        this.addRole("_g_:" + group, role);
    }

    @Override
    public void deleteGroupRole(String group, String role) {
        this.deleteRole("_g_:" + group, role);
    }

    protected void rawUpdate(Connection connection, String query, String ... params) throws SQLException {
        int rows = JDBCUtils.rawUpdate(connection, query, params);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Executing [%s], params=%s. %d rows affected.", query, Arrays.toString(params), rows));
        }
    }

    protected List<String> rawSelect(Connection connection, String query, String ... params) throws SQLException {
        return JDBCUtils.rawSelect(connection, query, params);
    }

    public String getAddUserStatement() {
        return this.addUserStatement;
    }

    public void setAddUserStatement(String addUserStatement) {
        this.addUserStatement = addUserStatement;
    }

    public String getAddRoleStatement() {
        return this.addRoleStatement;
    }

    public void setAddRoleStatement(String addRoleStatement) {
        this.addRoleStatement = addRoleStatement;
    }

    public String getDeleteRoleStatement() {
        return this.deleteRoleStatement;
    }

    public void setDeleteRoleStatement(String deleteRoleStatement) {
        this.deleteRoleStatement = deleteRoleStatement;
    }

    public String getDeleteAllUserRolesStatement() {
        return this.deleteAllUserRolesStatement;
    }

    public void setDeleteAllUserRolesStatement(String deleteAllUserRolesStatement) {
        this.deleteAllUserRolesStatement = deleteAllUserRolesStatement;
    }

    public String getDeleteUserStatement() {
        return this.deleteUserStatement;
    }

    public void setDeleteUserStatement(String deleteUserStatement) {
        this.deleteUserStatement = deleteUserStatement;
    }

    public String getSelectUsersQuery() {
        return this.selectUsersQuery;
    }

    public void setSelectUsersQuery(String selectUsersQuery) {
        this.selectUsersQuery = selectUsersQuery;
    }

    public String getSelectRolesQuery() {
        return this.selectRolesQuery;
    }

    public void setSelectRolesQuery(String selectRolesQuery) {
        this.selectRolesQuery = selectRolesQuery;
    }

    @Override
    public Map<GroupPrincipal, String> listGroups() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createGroup(String group) {
        throw new UnsupportedOperationException();
    }
}

