/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl.type;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.camunda.bpm.dmn.engine.impl.spi.type.DmnDataTypeTransformer;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class DateDataTypeTransformer
implements DmnDataTypeTransformer {
    protected SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    @Override
    public TypedValue transform(Object value) throws IllegalArgumentException {
        if (value instanceof Date) {
            return Variables.dateValue((Date)((Date)value));
        }
        if (value instanceof String) {
            Date date = this.transformString((String)value);
            return Variables.dateValue((Date)date);
        }
        throw new IllegalArgumentException();
    }

    protected Date transformString(String value) {
        try {
            return this.format.parse(value);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

