/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.IdGenerator;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.model.Properties;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.Deployer;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.camunda.bpm.engine.impl.repository.ResourceDefinitionEntity;

public abstract class AbstractDefinitionDeployer<DefinitionEntity extends ResourceDefinitionEntity>
implements Deployer {
    public static final String[] DIAGRAM_SUFFIXES = new String[]{"png", "jpg", "gif", "svg"};
    private final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected IdGenerator idGenerator;

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    @Override
    public void deploy(DeploymentEntity deployment) {
        this.LOG.debugProcessingDeployment(deployment.getName());
        Properties properties = new Properties();
        List<DefinitionEntity> definitions = this.parseDefinitionResources(deployment, properties);
        this.ensureNoDuplicateDefinitionKeys(definitions);
        this.postProcessDefinitions(deployment, definitions, properties);
    }

    protected List<DefinitionEntity> parseDefinitionResources(DeploymentEntity deployment, Properties properties) {
        ArrayList<DefinitionEntity> definitions = new ArrayList<DefinitionEntity>();
        for (ResourceEntity resource : deployment.getResources().values()) {
            this.LOG.debugProcessingResource(resource.getName());
            if (!this.isResourceHandled(resource)) continue;
            definitions.addAll(this.transformResource(deployment, resource, properties));
        }
        return definitions;
    }

    protected boolean isResourceHandled(ResourceEntity resource) {
        String resourceName = resource.getName();
        for (String suffix : this.getResourcesSuffixes()) {
            if (!resourceName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    protected abstract String[] getResourcesSuffixes();

    protected Collection<DefinitionEntity> transformResource(DeploymentEntity deployment, ResourceEntity resource, Properties properties) {
        String resourceName = resource.getName();
        List<DefinitionEntity> definitions = this.transformDefinitions(deployment, resource, properties);
        for (ResourceDefinitionEntity definition : definitions) {
            definition.setResourceName(resourceName);
            String diagramResourceName = this.getDiagramResourceForDefinition(deployment, resourceName, definition, deployment.getResources());
            if (diagramResourceName == null) continue;
            definition.setDiagramResourceName(diagramResourceName);
        }
        return definitions;
    }

    protected abstract List<DefinitionEntity> transformDefinitions(DeploymentEntity var1, ResourceEntity var2, Properties var3);

    protected String getDiagramResourceForDefinition(DeploymentEntity deployment, String resourceName, DefinitionEntity definition, Map<String, ResourceEntity> resources) {
        for (String diagramSuffix : this.getDiagramSuffixes()) {
            String definitionDiagramResource = this.getDefinitionDiagramResourceName(resourceName, definition, diagramSuffix);
            String diagramForFileResource = this.getGeneralDiagramResourceName(resourceName, definition, diagramSuffix);
            if (resources.containsKey(definitionDiagramResource)) {
                return definitionDiagramResource;
            }
            if (!resources.containsKey(diagramForFileResource)) continue;
            return diagramForFileResource;
        }
        return null;
    }

    protected String getDefinitionDiagramResourceName(String resourceName, DefinitionEntity definition, String diagramSuffix) {
        String fileResourceBase = this.stripDefinitionFileSuffix(resourceName);
        String definitionKey = definition.getKey();
        return fileResourceBase + definitionKey + "." + diagramSuffix;
    }

    protected String getGeneralDiagramResourceName(String resourceName, DefinitionEntity definition, String diagramSuffix) {
        String fileResourceBase = this.stripDefinitionFileSuffix(resourceName);
        return fileResourceBase + diagramSuffix;
    }

    protected String stripDefinitionFileSuffix(String resourceName) {
        for (String suffix : this.getResourcesSuffixes()) {
            if (!resourceName.endsWith(suffix)) continue;
            return resourceName.substring(0, resourceName.length() - suffix.length());
        }
        return resourceName;
    }

    protected String[] getDiagramSuffixes() {
        return DIAGRAM_SUFFIXES;
    }

    protected void ensureNoDuplicateDefinitionKeys(List<DefinitionEntity> definitions) {
        HashSet<String> keys = new HashSet<String>();
        for (ResourceDefinitionEntity definition : definitions) {
            String key = definition.getKey();
            if (keys.contains(key)) {
                throw new ProcessEngineException("The deployment contains definitions with the same key '" + key + "' (id attribute), this is not allowed");
            }
            keys.add(key);
        }
    }

    protected void postProcessDefinitions(DeploymentEntity deployment, List<DefinitionEntity> definitions, Properties properties) {
        if (deployment.isNew()) {
            this.persistDefinitions(deployment, definitions, properties);
        } else {
            this.loadDefinitions(deployment, definitions, properties);
        }
    }

    protected void persistDefinitions(DeploymentEntity deployment, List<DefinitionEntity> definitions, Properties properties) {
        for (ResourceDefinitionEntity definition : definitions) {
            String definitionKey = definition.getKey();
            String tenantId = deployment.getTenantId();
            DefinitionEntity latestDefinition = this.findLatestDefinitionByKeyAndTenantId(definitionKey, tenantId);
            this.updateDefinitionByLatestDefinition(deployment, definition, latestDefinition);
            this.persistDefinition(definition);
            this.registerDefinition(deployment, definition, properties);
        }
    }

    protected void updateDefinitionByLatestDefinition(DeploymentEntity deployment, DefinitionEntity definition, DefinitionEntity latestDefinition) {
        definition.setVersion(this.getNextVersion(deployment, definition, latestDefinition));
        definition.setId(this.generateDefinitionId(deployment, definition, latestDefinition));
        definition.setDeploymentId(deployment.getId());
        definition.setTenantId(deployment.getTenantId());
    }

    protected void loadDefinitions(DeploymentEntity deployment, List<DefinitionEntity> definitions, Properties properties) {
        for (ResourceDefinitionEntity definition : definitions) {
            String deploymentId = deployment.getId();
            String definitionKey = definition.getKey();
            DefinitionEntity persistedDefinition = this.findDefinitionByDeploymentAndKey(deploymentId, definitionKey);
            this.handlePersistedDefinition(definition, persistedDefinition, deployment, properties);
        }
    }

    protected void handlePersistedDefinition(DefinitionEntity definition, DefinitionEntity persistedDefinition, DeploymentEntity deployment, Properties properties) {
        this.persistedDefinitionLoaded(deployment, definition, persistedDefinition);
        this.updateDefinitionByPersistedDefinition(deployment, definition, persistedDefinition);
        this.registerDefinition(deployment, definition, properties);
    }

    protected void updateDefinitionByPersistedDefinition(DeploymentEntity deployment, DefinitionEntity definition, DefinitionEntity persistedDefinition) {
        definition.setVersion(persistedDefinition.getVersion());
        definition.setId(persistedDefinition.getId());
        definition.setDeploymentId(deployment.getId());
        definition.setTenantId(persistedDefinition.getTenantId());
    }

    protected void persistedDefinitionLoaded(DeploymentEntity deployment, DefinitionEntity definition, DefinitionEntity persistedDefinition) {
    }

    protected abstract DefinitionEntity findDefinitionByDeploymentAndKey(String var1, String var2);

    protected abstract DefinitionEntity findLatestDefinitionByKeyAndTenantId(String var1, String var2);

    protected abstract void persistDefinition(DefinitionEntity var1);

    protected void registerDefinition(DeploymentEntity deployment, DefinitionEntity definition, Properties properties) {
        DeploymentCache deploymentCache = this.getDeploymentCache();
        this.addDefinitionToDeploymentCache(deploymentCache, definition);
        this.definitionAddedToDeploymentCache(deployment, definition, properties);
        deployment.addDeployedArtifact(definition);
    }

    protected abstract void addDefinitionToDeploymentCache(DeploymentCache var1, DefinitionEntity var2);

    protected void definitionAddedToDeploymentCache(DeploymentEntity deployment, DefinitionEntity definition, Properties properties) {
    }

    protected int getNextVersion(DeploymentEntity deployment, DefinitionEntity newDefinition, DefinitionEntity latestDefinition) {
        int result = 1;
        if (latestDefinition != null) {
            int latestVersion = latestDefinition.getVersion();
            result = latestVersion + 1;
        }
        return result;
    }

    protected String generateDefinitionId(DeploymentEntity deployment, DefinitionEntity newDefinition, DefinitionEntity latestDefinition) {
        String nextId = this.idGenerator.getNextId();
        String definitionKey = newDefinition.getKey();
        int definitionVersion = newDefinition.getVersion();
        String definitionId = definitionKey + ":" + definitionVersion + ":" + nextId;
        if (definitionId.length() > 64) {
            definitionId = nextId;
        }
        return definitionId;
    }

    protected ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return Context.getProcessEngineConfiguration();
    }

    protected CommandContext getCommandContext() {
        return Context.getCommandContext();
    }

    protected DeploymentCache getDeploymentCache() {
        return this.getProcessEngineConfiguration().getDeploymentCache();
    }
}

