/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.SchemaOperationsCommand;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.DetermineHistoryLevelCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.db.PersistenceSession;
import org.camunda.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyEntity;

public final class SchemaOperationsProcessEngineBuild
implements SchemaOperationsCommand {
    private static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;

    @Override
    public Void execute(CommandContext commandContext) {
        String databaseSchemaUpdate = Context.getProcessEngineConfiguration().getDatabaseSchemaUpdate();
        PersistenceSession persistenceSession = commandContext.getSession(PersistenceSession.class);
        if ("drop-create".equals(databaseSchemaUpdate)) {
            try {
                persistenceSession.dbSchemaDrop();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if ("create-drop".equals(databaseSchemaUpdate) || "drop-create".equals(databaseSchemaUpdate) || "create".equals(databaseSchemaUpdate)) {
            persistenceSession.dbSchemaCreate();
        } else if ("false".equals(databaseSchemaUpdate)) {
            persistenceSession.dbSchemaCheckVersion();
        } else if ("true".equals(databaseSchemaUpdate)) {
            persistenceSession.dbSchemaUpdate();
        }
        DbEntityManager entityManager = commandContext.getSession(DbEntityManager.class);
        this.checkHistoryLevel(entityManager);
        this.checkDeploymentLockExists(entityManager);
        return null;
    }

    public static void dbCreateHistoryLevel(DbEntityManager entityManager) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        HistoryLevel configuredHistoryLevel = processEngineConfiguration.getHistoryLevel();
        PropertyEntity property = new PropertyEntity("historyLevel", Integer.toString(configuredHistoryLevel.getId()));
        entityManager.insert(property);
        LOG.creatingHistoryLevelPropertyInDatabase(configuredHistoryLevel);
    }

    public static Integer databaseHistoryLevel(DbEntityManager entityManager) {
        try {
            PropertyEntity historyLevelProperty = entityManager.selectById(PropertyEntity.class, "historyLevel");
            return historyLevelProperty != null ? new Integer(historyLevelProperty.getValue()) : null;
        }
        catch (Exception e) {
            LOG.couldNotSelectHistoryLevel(e.getMessage());
            return null;
        }
    }

    public void checkHistoryLevel(DbEntityManager entityManager) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        HistoryLevel databaseHistoryLevel = new DetermineHistoryLevelCmd(processEngineConfiguration.getHistoryLevels()).execute(Context.getCommandContext());
        this.determineAutoHistoryLevel(processEngineConfiguration, databaseHistoryLevel);
        HistoryLevel configuredHistoryLevel = processEngineConfiguration.getHistoryLevel();
        if (databaseHistoryLevel == null) {
            LOG.noHistoryLevelPropertyFound();
            SchemaOperationsProcessEngineBuild.dbCreateHistoryLevel(entityManager);
        } else if (!Integer.valueOf(configuredHistoryLevel.getId()).equals(databaseHistoryLevel.getId())) {
            throw new ProcessEngineException("historyLevel mismatch: configuration says " + configuredHistoryLevel + " and database says " + databaseHistoryLevel);
        }
    }

    protected void determineAutoHistoryLevel(ProcessEngineConfigurationImpl engineConfiguration, HistoryLevel databaseHistoryLevel) {
        HistoryLevel configuredHistoryLevel = engineConfiguration.getHistoryLevel();
        if (configuredHistoryLevel == null && "auto".equals(engineConfiguration.getHistory())) {
            if (databaseHistoryLevel != null) {
                engineConfiguration.setHistoryLevel(databaseHistoryLevel);
            } else {
                engineConfiguration.setHistoryLevel(engineConfiguration.getDefaultHistoryLevel());
            }
        }
    }

    public void checkDeploymentLockExists(DbEntityManager entityManager) {
        PropertyEntity deploymentLockProperty = entityManager.selectById(PropertyEntity.class, "deployment.lock");
        if (deploymentLockProperty == null) {
            LOG.noDeploymentLockPropertyFound();
        }
    }
}

