/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.identity.db;

import java.util.HashMap;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.Tenant;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.identity.WritableIdentityProvider;
import org.camunda.bpm.engine.impl.identity.db.DbReadOnlyIdentityServiceProvider;
import org.camunda.bpm.engine.impl.persistence.entity.GroupEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MembershipEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TenantEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TenantMembershipEntity;
import org.camunda.bpm.engine.impl.persistence.entity.UserEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DbIdentityServiceProvider
extends DbReadOnlyIdentityServiceProvider
implements WritableIdentityProvider {
    @Override
    public UserEntity createNewUser(String userId) {
        this.checkAuthorization(Permissions.CREATE, Resources.USER, null);
        return new UserEntity(userId);
    }

    @Override
    public User saveUser(User user) {
        UserEntity userEntity = (UserEntity)user;
        userEntity.encryptPassword();
        if (userEntity.getRevision() == 0) {
            this.checkAuthorization(Permissions.CREATE, Resources.USER, null);
            this.getDbEntityManager().insert(userEntity);
            this.createDefaultAuthorizations(userEntity);
        } else {
            this.checkAuthorization(Permissions.UPDATE, Resources.USER, user.getId());
            this.getDbEntityManager().merge(userEntity);
        }
        return userEntity;
    }

    @Override
    public void deleteUser(String userId) {
        this.checkAuthorization(Permissions.DELETE, Resources.USER, userId);
        UserEntity user = this.findUserById(userId);
        if (user != null) {
            this.deleteMembershipsByUserId(userId);
            this.deleteTenantMembershipsOfUser(userId);
            this.deleteAuthorizations(Resources.USER, userId);
            this.getDbEntityManager().delete(user);
        }
    }

    @Override
    public GroupEntity createNewGroup(String groupId) {
        this.checkAuthorization(Permissions.CREATE, Resources.GROUP, null);
        return new GroupEntity(groupId);
    }

    @Override
    public GroupEntity saveGroup(Group group) {
        GroupEntity groupEntity = (GroupEntity)group;
        if (groupEntity.getRevision() == 0) {
            this.checkAuthorization(Permissions.CREATE, Resources.GROUP, null);
            this.getDbEntityManager().insert(groupEntity);
            this.createDefaultAuthorizations(group);
        } else {
            this.checkAuthorization(Permissions.UPDATE, Resources.GROUP, group.getId());
            this.getDbEntityManager().merge(groupEntity);
        }
        return groupEntity;
    }

    @Override
    public void deleteGroup(String groupId) {
        this.checkAuthorization(Permissions.DELETE, Resources.GROUP, groupId);
        GroupEntity group = this.findGroupById(groupId);
        if (group != null) {
            this.deleteMembershipsByGroupId(groupId);
            this.deleteTenantMembershipsOfGroup(groupId);
            this.deleteAuthorizations(Resources.GROUP, groupId);
            this.getDbEntityManager().delete(group);
        }
    }

    @Override
    public Tenant createNewTenant(String tenantId) {
        this.checkAuthorization(Permissions.CREATE, Resources.TENANT, null);
        return new TenantEntity(tenantId);
    }

    @Override
    public Tenant saveTenant(Tenant tenant) {
        TenantEntity tenantEntity = (TenantEntity)tenant;
        if (tenantEntity.getRevision() == 0) {
            this.checkAuthorization(Permissions.CREATE, Resources.TENANT, null);
            this.getDbEntityManager().insert(tenantEntity);
            this.createDefaultAuthorizations(tenant);
        } else {
            this.checkAuthorization(Permissions.UPDATE, Resources.TENANT, tenant.getId());
            this.getDbEntityManager().merge(tenantEntity);
        }
        return tenantEntity;
    }

    @Override
    public void deleteTenant(String tenantId) {
        this.checkAuthorization(Permissions.DELETE, Resources.TENANT, tenantId);
        TenantEntity tenant = this.findTenantById(tenantId);
        if (tenant != null) {
            this.deleteTenantMembershipsOfTenant(tenantId);
            this.deleteAuthorizations(Resources.TENANT, tenantId);
            this.getDbEntityManager().delete(tenant);
        }
    }

    @Override
    public void createMembership(String userId, String groupId) {
        this.checkAuthorization(Permissions.CREATE, Resources.GROUP_MEMBERSHIP, groupId);
        UserEntity user = this.findUserById(userId);
        GroupEntity group = this.findGroupById(groupId);
        MembershipEntity membership = new MembershipEntity();
        membership.setUser(user);
        membership.setGroup(group);
        this.getDbEntityManager().insert(membership);
        this.createDefaultMembershipAuthorizations(userId, groupId);
    }

    @Override
    public void deleteMembership(String userId, String groupId) {
        this.checkAuthorization(Permissions.DELETE, Resources.GROUP_MEMBERSHIP, groupId);
        this.deleteAuthorizations(Resources.GROUP_MEMBERSHIP, groupId);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("userId", userId);
        parameters.put("groupId", groupId);
        this.getDbEntityManager().delete(MembershipEntity.class, "deleteMembership", parameters);
    }

    protected void deleteMembershipsByUserId(String userId) {
        this.getDbEntityManager().delete(MembershipEntity.class, "deleteMembershipsByUserId", userId);
    }

    protected void deleteMembershipsByGroupId(String groupId) {
        this.getDbEntityManager().delete(MembershipEntity.class, "deleteMembershipsByGroupId", groupId);
    }

    @Override
    public void createTenantUserMembership(String tenantId, String userId) {
        this.checkAuthorization(Permissions.CREATE, Resources.TENANT_MEMBERSHIP, tenantId);
        TenantEntity tenant = this.findTenantById(tenantId);
        UserEntity user = this.findUserById(userId);
        EnsureUtil.ensureNotNull("No tenant found with id '" + tenantId + "'.", "tenant", (Object)tenant);
        EnsureUtil.ensureNotNull("No user found with id '" + userId + "'.", "user", (Object)user);
        TenantMembershipEntity membership = new TenantMembershipEntity();
        membership.setTenant(tenant);
        membership.setUser(user);
        this.getDbEntityManager().insert(membership);
        this.createDefaultTenantMembershipAuthorizations((Tenant)tenant, user);
    }

    @Override
    public void createTenantGroupMembership(String tenantId, String groupId) {
        this.checkAuthorization(Permissions.CREATE, Resources.TENANT_MEMBERSHIP, tenantId);
        TenantEntity tenant = this.findTenantById(tenantId);
        GroupEntity group = this.findGroupById(groupId);
        EnsureUtil.ensureNotNull("No tenant found with id '" + tenantId + "'.", "tenant", (Object)tenant);
        EnsureUtil.ensureNotNull("No group found with id '" + groupId + "'.", "group", (Object)group);
        TenantMembershipEntity membership = new TenantMembershipEntity();
        membership.setTenant(tenant);
        membership.setGroup(group);
        this.getDbEntityManager().insert(membership);
        this.createDefaultTenantMembershipAuthorizations((Tenant)tenant, group);
    }

    @Override
    public void deleteTenantUserMembership(String tenantId, String userId) {
        this.checkAuthorization(Permissions.DELETE, Resources.TENANT_MEMBERSHIP, tenantId);
        this.deleteAuthorizations(Resources.TENANT_MEMBERSHIP, userId);
        this.deleteAuthorizationsForUser(Resources.TENANT, tenantId, userId);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("tenantId", tenantId);
        parameters.put("userId", userId);
        this.getDbEntityManager().delete(TenantMembershipEntity.class, "deleteTenantMembership", parameters);
    }

    @Override
    public void deleteTenantGroupMembership(String tenantId, String groupId) {
        this.checkAuthorization(Permissions.DELETE, Resources.TENANT_MEMBERSHIP, tenantId);
        this.deleteAuthorizations(Resources.TENANT_MEMBERSHIP, groupId);
        this.deleteAuthorizationsForGroup(Resources.TENANT, tenantId, groupId);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("tenantId", tenantId);
        parameters.put("groupId", groupId);
        this.getDbEntityManager().delete(TenantMembershipEntity.class, "deleteTenantMembership", parameters);
    }

    protected void deleteTenantMembershipsOfUser(String userId) {
        this.getDbEntityManager().delete(TenantMembershipEntity.class, "deleteTenantMembershipsOfUser", userId);
    }

    protected void deleteTenantMembershipsOfGroup(String groupId) {
        this.getDbEntityManager().delete(TenantMembershipEntity.class, "deleteTenantMembershipsOfGroup", groupId);
    }

    protected void deleteTenantMembershipsOfTenant(String tenant) {
        this.getDbEntityManager().delete(TenantMembershipEntity.class, "deleteTenantMembershipsOfTenant", tenant);
    }

    protected void createDefaultAuthorizations(UserEntity userEntity) {
        if (Context.getProcessEngineConfiguration().isAuthorizationEnabled()) {
            this.saveDefaultAuthorizations(this.getResourceAuthorizationProvider().newUser(userEntity));
        }
    }

    protected void createDefaultAuthorizations(Group group) {
        if (this.isAuthorizationEnabled()) {
            this.saveDefaultAuthorizations(this.getResourceAuthorizationProvider().newGroup(group));
        }
    }

    protected void createDefaultAuthorizations(Tenant tenant) {
        if (this.isAuthorizationEnabled()) {
            this.saveDefaultAuthorizations(this.getResourceAuthorizationProvider().newTenant(tenant));
        }
    }

    protected void createDefaultMembershipAuthorizations(String userId, String groupId) {
        if (this.isAuthorizationEnabled()) {
            this.saveDefaultAuthorizations(this.getResourceAuthorizationProvider().groupMembershipCreated(groupId, userId));
        }
    }

    protected void createDefaultTenantMembershipAuthorizations(Tenant tenant, User user) {
        if (this.isAuthorizationEnabled()) {
            this.saveDefaultAuthorizations(this.getResourceAuthorizationProvider().tenantMembershipCreated(tenant, user));
        }
    }

    protected void createDefaultTenantMembershipAuthorizations(Tenant tenant, Group group) {
        if (this.isAuthorizationEnabled()) {
            this.saveDefaultAuthorizations(this.getResourceAuthorizationProvider().tenantMembershipCreated(tenant, group));
        }
    }
}

