/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.xml.impl.type.attribute;

import org.camunda.bpm.model.xml.impl.type.attribute.AttributeImpl;
import org.camunda.bpm.model.xml.type.ModelElementType;

public class NamedEnumAttribute<T extends Enum<T>>
extends AttributeImpl<T> {
    protected final Class<T> type;

    public NamedEnumAttribute(ModelElementType owningElementType, Class<T> type) {
        super(owningElementType);
        this.type = type;
    }

    @Override
    protected T convertXmlValueToModelValue(String rawValue) {
        Enum[] enumConstants = (Enum[])this.type.getEnumConstants();
        if (rawValue != null && enumConstants != null) {
            for (Enum enumConstant : enumConstants) {
                if (!rawValue.equals(enumConstant.toString())) continue;
                return (T)enumConstant;
            }
        }
        return null;
    }

    @Override
    protected String convertModelValueToXmlValue(T modelValue) {
        return ((Enum)modelValue).toString();
    }
}

