/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.osgi.scripting.impl;

import java.util.Collection;
import java.util.logging.Logger;
import javax.script.ScriptEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.scripting.engine.ScriptBindingsFactory;
import org.camunda.bpm.engine.impl.scripting.engine.ScriptingEngines;
import org.camunda.bpm.extension.osgi.scripting.ScriptEngineResolver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class OsgiScriptingEngines
extends ScriptingEngines {
    private static final Logger LOGGER = Logger.getLogger(OsgiScriptingEngines.class.getName());
    private BundleContext context;

    public OsgiScriptingEngines(ScriptBindingsFactory scriptBindingsFactory) {
        super(scriptBindingsFactory);
    }

    public ScriptEngine getScriptEngineForLanguage(String language) {
        ScriptEngine scriptEngine = null;
        try {
            scriptEngine = this.resolveScriptEngine(language);
        }
        catch (InvalidSyntaxException e) {
            throw new ProcessEngineException("problem resolving scripting engine" + e.getMessage(), (Throwable)e);
        }
        if (scriptEngine == null) {
            throw new ProcessEngineException("Can't find scripting engine for '" + language + "'");
        }
        return scriptEngine;
    }

    protected BundleContext getBundleContext() {
        if (this.context == null) {
            this.context = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        }
        return this.context;
    }

    ScriptEngine resolveScriptEngine(String scriptEngineName) throws InvalidSyntaxException {
        Collection refs = this.getBundleContext().getServiceReferences(ScriptEngineResolver.class, null);
        if (refs == null) {
            LOGGER.info("No OSGi script engine resolvers available!");
            return null;
        }
        LOGGER.fine("Found " + refs.size() + " OSGi ScriptEngineResolver services");
        for (ServiceReference ref : refs) {
            ScriptEngineResolver resolver = (ScriptEngineResolver)this.getBundleContext().getService(ref);
            ScriptEngine engine = resolver.resolveScriptEngine(scriptEngineName);
            this.getBundleContext().ungetService(ref);
            LOGGER.fine("OSGi resolver " + resolver + " produced " + scriptEngineName + " engine " + engine);
            if (engine == null) continue;
            return engine;
        }
        return null;
    }
}

