/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.download.impl;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.karaf.features.internal.download.impl.AbstractRetryableDownloadTask;
import org.ops4j.pax.url.mvn.MavenResolver;

public class MavenDownloadTask
extends AbstractRetryableDownloadTask {
    private final MavenResolver resolver;

    public MavenDownloadTask(ScheduledExecutorService executor, MavenResolver resolver, String url) {
        super(executor, url);
        this.resolver = resolver;
    }

    @Override
    protected File download(Exception previousException) throws Exception {
        return this.resolver.resolve(this.url, previousException);
    }

    @Override
    protected AbstractRetryableDownloadTask.Retry isRetryable(IOException e) {
        switch (this.resolver.isRetryableException((Exception)e)) {
            case NEVER: {
                return AbstractRetryableDownloadTask.Retry.NO_RETRY;
            }
            case LOW: 
            case HIGH: {
                return AbstractRetryableDownloadTask.Retry.QUICK_RETRY;
            }
        }
        return AbstractRetryableDownloadTask.Retry.DEFAULT_RETRY;
    }
}

