/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.dm.impl.Logger;

public class SerialExecutor
implements Executor {
    protected final ConcurrentLinkedQueue m_tasks = new ConcurrentLinkedQueue();
    protected final AtomicReference m_runningThread = new AtomicReference();
    private final Logger m_logger;

    public SerialExecutor(Logger logger) {
        this.m_logger = logger;
    }

    public void enqueue(Runnable task) {
        this.m_tasks.add(task);
    }

    public void execute() {
        Thread currentThread = Thread.currentThread();
        if (this.m_runningThread.compareAndSet(null, currentThread)) {
            this.runTasks(currentThread);
        }
    }

    public void execute(Runnable task) {
        Thread currentThread = Thread.currentThread();
        if (this.m_runningThread.get() == currentThread) {
            this.runTask(task);
        } else {
            this.enqueue(task);
            this.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTasks(Thread currentRunninghread) {
        do {
            try {
                Runnable task;
                ConcurrentLinkedQueue tasks = this.m_tasks;
                while ((task = (Runnable)tasks.poll()) != null) {
                    this.runTask(task);
                }
            }
            finally {
                this.m_runningThread.set(null);
            }
        } while (!this.m_tasks.isEmpty() && this.m_runningThread.compareAndSet(null, currentRunninghread));
    }

    void runTask(Runnable command) {
        try {
            command.run();
        }
        catch (Throwable t) {
            if (this.m_logger != null) {
                this.m_logger.log(1, "Error processing tasks", t);
            }
            t.printStackTrace();
        }
    }

    public String toString() {
        return "[Executor: queue size: " + this.m_tasks.size() + "]";
    }
}

