/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DeleteHistoricProcessInstancesCmd
implements Command<Void>,
Serializable {
    protected final List<String> processInstanceIds;

    public DeleteHistoricProcessInstancesCmd(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "processInstanceIds", this.processInstanceIds);
        List instances = new HistoricProcessInstanceQueryImpl().processInstanceIds(new HashSet<String>(this.processInstanceIds)).list();
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "No historic process instances found ", instances);
        EnsureUtil.ensureNumberOfElements("historic process instances", instances, this.processInstanceIds.size());
        for (HistoricProcessInstance historicProcessInstance : instances) {
            for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
                checker.checkDeleteHistoricProcessInstance(historicProcessInstance);
            }
            EnsureUtil.ensureNotNull("Process instance is still running, cannot delete historic process instance: " + historicProcessInstance, "instance.getEndTime()", (Object)historicProcessInstance.getEndTime());
            String toDelete = historicProcessInstance.getId();
            commandContext.getHistoricProcessInstanceManager().deleteHistoricProcessInstanceById(toDelete);
        }
        return null;
    }
}

