/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.core.variable.scope;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableInstance;
import org.camunda.bpm.engine.impl.core.variable.scope.VariableCollectionProvider;

public class VariableStore<T extends CoreVariableInstance> {
    protected VariablesProvider<T> variablesProvider;
    protected Map<String, T> variables;
    protected List<VariableStoreObserver<T>> observers;

    public VariableStore() {
        this(VariableCollectionProvider.emptyVariables(), new VariableStoreObserver[0]);
    }

    public VariableStore(VariablesProvider<T> provider, VariableStoreObserver<T> ... observers) {
        this.variablesProvider = provider;
        this.observers = new ArrayList<VariableStoreObserver<T>>();
        this.observers.addAll(Arrays.asList(observers));
    }

    public void setVariablesProvider(VariablesProvider<T> variablesProvider) {
        if (this.variables != null) {
            return;
        }
        this.variablesProvider = variablesProvider;
    }

    protected Map<String, T> getVariablesMap() {
        this.forceInitialization();
        return this.variables;
    }

    public T getVariable(String name) {
        return (T)((CoreVariableInstance)this.getVariablesMap().get(name));
    }

    public List<T> getVariables() {
        return new ArrayList<T>(this.getVariablesMap().values());
    }

    public void addVariable(T value) {
        if (this.containsKey(value.getName())) {
            throw ProcessEngineLogger.CORE_LOGGER.duplicateVariableInstanceException((CoreVariableInstance)value);
        }
        this.getVariablesMap().put(value.getName(), value);
        for (VariableStoreObserver<T> listener : this.observers) {
            listener.onAdd(value);
        }
    }

    public void updateVariable(T value) {
        if (!this.containsKey(value.getName())) {
            throw ProcessEngineLogger.CORE_LOGGER.duplicateVariableInstanceException((CoreVariableInstance)value);
        }
    }

    public boolean isEmpty() {
        return this.getVariablesMap().isEmpty();
    }

    public boolean containsValue(T value) {
        return this.getVariablesMap().containsValue(value);
    }

    public boolean containsKey(String key) {
        return this.getVariablesMap().containsKey(key);
    }

    public Set<String> getKeys() {
        return new HashSet<String>(this.getVariablesMap().keySet());
    }

    public boolean isInitialized() {
        return this.variables != null;
    }

    public void forceInitialization() {
        if (!this.isInitialized()) {
            this.variables = new HashMap<String, T>();
            for (CoreVariableInstance variable : this.variablesProvider.provideVariables()) {
                this.variables.put(variable.getName(), variable);
            }
        }
    }

    public T removeVariable(String variableName) {
        if (!this.getVariablesMap().containsKey(variableName)) {
            return null;
        }
        CoreVariableInstance value = (CoreVariableInstance)this.getVariablesMap().remove(variableName);
        for (VariableStoreObserver<CoreVariableInstance> variableStoreObserver : this.observers) {
            variableStoreObserver.onRemove(value);
        }
        return (T)value;
    }

    public void removeVariables() {
        Iterator<T> valuesIt = this.getVariablesMap().values().iterator();
        while (valuesIt.hasNext()) {
            CoreVariableInstance nextVariable = (CoreVariableInstance)valuesIt.next();
            valuesIt.remove();
            for (VariableStoreObserver<CoreVariableInstance> variableStoreObserver : this.observers) {
                variableStoreObserver.onRemove(nextVariable);
            }
        }
    }

    public void addObserver(VariableStoreObserver<T> observer) {
        this.observers.add(observer);
    }

    public void removeObserver(VariableStoreObserver<T> observer) {
        this.observers.remove(observer);
    }

    public static interface VariablesProvider<T extends CoreVariableInstance> {
        public Collection<T> provideVariables();
    }

    public static interface VariableStoreObserver<T extends CoreVariableInstance> {
        public void onAdd(T var1);

        public void onRemove(T var1);
    }
}

